/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.sync.service;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.service.sync.change.EntityAdded;
import com.android.tools.idea.gradle.service.sync.change.EntityAddedImpl;
import com.android.tools.idea.gradle.service.sync.change.ProjectStructureChange;
import com.android.tools.idea.gradle.service.sync.service.AbstractIde2GradleProjectSyncService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.service.project.ProjectStructureHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;

public class Ide2GradleModuleDependencyService
extends AbstractIde2GradleProjectSyncService<ModuleDependencyData> {
    private static final Logger LOG = Logger.getInstance(Ide2GradleModuleDependencyService.class);

    @Override
    public Key<ModuleDependencyData> getKey() {
        return ProjectKeys.MODULE_DEPENDENCY;
    }

    @Override
    public ProjectStructureChange<ModuleDependencyData> build(DataNode<ModuleDependencyData> previousStateNode, DataNode<ModuleDependencyData> currentStateNode, Project project) {
        if (previousStateNode == null && currentStateNode != null) {
            return new EntityAddedImpl<ModuleDependencyData>(currentStateNode);
        }
        return null;
    }

    @Override
    protected boolean processEntityAddition(EntityAdded<ModuleDependencyData> change, Project ideProject) {
        ModuleDependencyData data = (ModuleDependencyData)change.getAddedEntity().getData();
        ProjectStructureHelper helper = (ProjectStructureHelper)ServiceManager.getService(ProjectStructureHelper.class);
        Module ownerIdeModule = helper.findIdeModule(data.getOwnerModule(), ideProject);
        if (ownerIdeModule == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Skipping change '%s' by ide -> gradle sync service %s. Reason: can't find matching owner ide module", change, this.getClass()));
            }
            return false;
        }
        VirtualFile ownerModuleGradleFile = GradleUtil.getGradleBuildFile(ownerIdeModule);
        if (ownerModuleGradleFile == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Skipping change '%s' by ide -> gradle sync service %s. Reason: can't find matching gradle config file for owner ide module '%s'", change, this.getClass(), ownerIdeModule.getName()));
            }
            return false;
        }
        Module dependencyIdeModule = helper.findIdeModule((ModuleData)data.getTarget(), ideProject);
        if (dependencyIdeModule == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Skipping change '%s' by ide -> gradle sync service %s. Reason: can't find matching dependency ide module", change, this.getClass()));
            }
            return false;
        }
        String dependencyModuleGradleConfigPath = GradleUtil.getGradlePath(dependencyIdeModule);
        if (dependencyModuleGradleConfigPath == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Skipping change '%s' by ide -> gradle sync service %s. Reason: can't find matching gradle config file for dependency ide module '%s'", change, this.getClass(), dependencyIdeModule.getName()));
            }
            return false;
        }
        final GradleBuildFile buildFile = new GradleBuildFile(ownerModuleGradleFile, ideProject);
        final List<BuildFileStatement> dependencies = buildFile.getDependencies();
        final Dependency newGradleDependency = new Dependency(Dependency.Scope.COMPILE, Dependency.Type.MODULE, dependencyModuleGradleConfigPath);
        for (BuildFileStatement statement : dependencies) {
            Dependency dependency;
            if (!(statement instanceof Dependency) || !(dependency = (Dependency)statement).matches(newGradleDependency)) continue;
            return true;
        }
        WriteCommandAction.runWriteCommandAction((Project)ideProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList newDependencies = Lists.newArrayList((Iterable)dependencies);
                newDependencies.add(newGradleDependency);
                buildFile.setValue(BuildFileKey.DEPENDENCIES, newDependencies);
            }
        });
        return true;
    }
}

