/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;

public class StopGradleDaemonsHyperlink
extends NotificationHyperlink {
    public static NotificationHyperlink createStopGradleDaemonsHyperlink() {
        if (ApplicationManager.getApplication().isRestartCapable()) {
            return new StopGradleDaemonsHyperlink();
        }
        return new OpenUrlHyperlink("http://www.gradle.org/docs/current/userguide/gradle_daemon.html", "Open Gradle Daemon documentation");
    }

    private StopGradleDaemonsHyperlink() {
        super("stopGradleDaemons", "Stop Gradle build processes (requires restart)");
    }

    @Override
    protected void execute(Project project) {
        String message = "Stopping all Gradle daemons will terminate any running Gradle builds (e.g. from the command line).\nThis action will also restart the IDE.\n\nDo you want to continue?";
        String title = "Stop Gradle Daemons";
        int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            GradleUtil.stopAllGradleDaemonsAndRestart();
        }
    }
}

