/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallPlatformHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenAndroidSdkManagerHyperlink;
import com.google.common.collect.Lists;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class MissingPlatformErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern MISSING_PLATFORM_PATTERN_1 = Pattern.compile("(Cause: )?failed to find target (.*) : (.*)");
    private static final Pattern MISSING_PLATFORM_PATTERN_2 = Pattern.compile("(Cause: )?failed to find target (.*)");

    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String firstLine = message.get(0);
        Matcher matcher = MISSING_PLATFORM_PATTERN_1.matcher(firstLine);
        boolean missingPlatform = matcher.matches();
        if (!missingPlatform) {
            matcher = MISSING_PLATFORM_PATTERN_2.matcher(firstLine);
            missingPlatform = matcher.matches();
        }
        if (missingPlatform) {
            List facets;
            AndroidVersion version;
            String loadError = null;
            ArrayList hyperlinks = Lists.newArrayList();
            String platform = matcher.group(2);
            LocalSdk localAndroidSdk = null;
            AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData != null) {
                localAndroidSdk = androidSdkData.getLocalSdk();
            }
            if (localAndroidSdk != null && (version = AndroidTargetHash.getPlatformVersion((String)platform)) != null) {
                LocalPkgInfo pkgInfo = localAndroidSdk.getPkgInfo(PkgType.PKG_PLATFORM, version);
                if (pkgInfo != null) {
                    loadError = pkgInfo.getLoadError();
                }
                hyperlinks.add(new InstallPlatformHyperlink(version));
            }
            if (hyperlinks.isEmpty() && !(facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
                hyperlinks.add(new OpenAndroidSdkManagerHyperlink());
            }
            String newMsg = error.getMessage();
            if (StringUtil.isNotEmpty(loadError)) {
                newMsg = newMsg + "\nPossible cause: " + loadError;
            }
            MissingPlatformErrorHandler.updateNotification(notification, project, newMsg, hyperlinks);
            return true;
        }
        return false;
    }
}

