/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import java.util.List;
import org.jetbrains.plugins.gradle.codeInsight.actions.AddGradleDslPluginAction;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleDslMethodNotFoundErrorHandler
extends AbstractSyncErrorHandler {
    @Override
    public boolean handleError(List<String> message, ExternalSystemException error, NotificationData notification, Project project) {
        String firstLine = message.get(0);
        if (firstLine != null && firstLine.startsWith("Gradle DSL method not found")) {
            VirtualFile virtualFile;
            String filePath = notification.getFilePath();
            VirtualFile virtualFile2 = virtualFile = filePath != null ? LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath) : null;
            if (virtualFile != null && "build.gradle".equals(virtualFile.getName())) {
                NotificationHyperlink gradleSettingsHyperlink = GradleDslMethodNotFoundErrorHandler.getGradleSettingsHyperlink(project);
                NotificationHyperlink applyGradlePluginHyperlink = GradleDslMethodNotFoundErrorHandler.getApplyGradlePluginHyperlink(virtualFile, notification);
                FixGradleModelVersionHyperlink upgradeAndroidPluginHyperlink = new FixGradleModelVersionHyperlink(false);
                String newMsg = firstLine + "\nPossible causes:<ul>";
                if (!GradleDslMethodNotFoundErrorHandler.gradleModelIsRecent(project)) {
                    newMsg = newMsg + String.format("<li>The project '%1$s' may be using a version of the Android Gradle plug-in that does not contain the method (e.g. 'testCompile' was added in 1.1.0).\n", project.getName()) + upgradeAndroidPluginHyperlink.toHtml() + "</li>";
                }
                newMsg = newMsg + String.format("<li>The project '%1$s' may be using a version of Gradle that does not contain the method.\n", project.getName()) + gradleSettingsHyperlink.toHtml() + "</li>" + "<li>The build file may be missing a Gradle plugin.\n" + applyGradlePluginHyperlink.toHtml() + "</li>";
                String title = String.format("Failed to sync Gradle project '%1$s'", project.getName());
                notification.setTitle(title);
                notification.setMessage(newMsg);
                notification.setNotificationCategory(NotificationCategory.convert((NotificationType)DEFAULT_NOTIFICATION_TYPE));
                GradleDslMethodNotFoundErrorHandler.addNotificationListener(notification, project, gradleSettingsHyperlink, applyGradlePluginHyperlink, upgradeAndroidPluginHyperlink);
            } else if (virtualFile != null && notification.getLine() > 0 && notification.getNavigatable() == null) {
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, notification.getLine() - 1, -1);
                notification.setNavigatable((Navigatable)descriptor);
            } else {
                GradleDslMethodNotFoundErrorHandler.updateNotification(notification, project, error.getMessage(), new NotificationHyperlink[0]);
            }
            return true;
        }
        return false;
    }

    private static NotificationHyperlink getGradleSettingsHyperlink(Project project) {
        VirtualFile virtualFile;
        File wrapperPropertiesFile;
        if (GradleDslMethodNotFoundErrorHandler.isUsingWrapper(project) && (wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project)) != null && (virtualFile = VfsUtil.findFileByIoFile((File)wrapperPropertiesFile, (boolean)true)) != null) {
            return new NotificationHyperlink("open.wrapper.file", "Open Gradle wrapper file"){

                @Override
                protected void execute(Project project) {
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
                    FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                }
            };
        }
        return new OpenGradleSettingsHyperlink();
    }

    private static boolean gradleModelIsRecent(Project project) {
        FullRevision fromBuildFile = GradleUtil.getAndroidGradleModelVersionFromBuildFile(project);
        if (fromBuildFile != null) {
            return fromBuildFile.compareTo((FullRevision)PreciseRevision.parseRevision((String)"1.5.0")) >= 0;
        }
        return false;
    }

    private static boolean isUsingWrapper(Project project) {
        GradleProjectSettings gradleSettings = GradleUtil.getGradleProjectSettings(project);
        File wrapperPropertiesFile = GradleUtil.findWrapperPropertiesFile(project);
        DistributionType distributionType = gradleSettings != null ? gradleSettings.getDistributionType() : null;
        return (distributionType == null || distributionType == DistributionType.DEFAULT_WRAPPED) && wrapperPropertiesFile != null;
    }

    private static NotificationHyperlink getApplyGradlePluginHyperlink(final VirtualFile virtualFile, final NotificationData notification) {
        return new NotificationHyperlink("apply.gradle.plugin", "Apply Gradle plugin"){

            @Override
            protected void execute(Project project) {
                GradleDslMethodNotFoundErrorHandler.openFile(virtualFile, notification, project);
                ActionManager actionManager = ActionManager.getInstance();
                String actionId = "AddGradleDslPluginAction";
                AnAction action = actionManager.getAction(actionId);
                assert (action instanceof AddGradleDslPluginAction);
                AddGradleDslPluginAction addPluginAction = (AddGradleDslPluginAction)action;
                actionManager.tryToExecute((AnAction)addPluginAction, ActionCommand.getInputEvent((String)actionId), null, "unknown", true);
            }
        };
    }

    private static void openFile(VirtualFile virtualFile, NotificationData notification, Project project) {
        int line = notification.getLine() - 1;
        int column = notification.getColumn() - 1;
        line = line < 0 ? -1 : line;
        column = column < 0 ? -1 : column + 1;
        new OpenFileDescriptor(project, virtualFile, line, column).navigate(true);
    }
}

