/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;

public abstract class AbstractSyncErrorHandler {
    public static final ExtensionPointName<AbstractSyncErrorHandler> EP_NAME = ExtensionPointName.create((String)"com.android.gradle.syncErrorHandler");
    public static final String FAILED_TO_SYNC_GRADLE_PROJECT_ERROR_GROUP_FORMAT = "Failed to sync Gradle project '%1$s'";
    protected static final NotificationHyperlink[] EMPTY = new NotificationHyperlink[0];
    private static final Pattern ERROR_LOCATION_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)' line: ([\\d]+)");
    private static final Pattern ERROR_IN_FILE_PATTERN = Pattern.compile("Build file '(.*)'");
    protected static final NotificationType DEFAULT_NOTIFICATION_TYPE = NotificationType.ERROR;

    public abstract boolean handleError(List<String> var1, ExternalSystemException var2, NotificationData var3, Project var4);

    protected static Pair<String, Integer> getErrorLocation(String msg) {
        Matcher matcher = ERROR_LOCATION_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            try {
                line = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        matcher = ERROR_IN_FILE_PATTERN.matcher(msg);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            return Pair.create((Object)filePath, (Object)-1);
        }
        return null;
    }

    protected static void updateNotification(NotificationData notification, Project project, String errorMsg, List<NotificationHyperlink> hyperlinks) {
        AbstractSyncErrorHandler.updateNotification(notification, project, errorMsg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    protected static void updateNotification(NotificationData notification, Project project, String errorMsg, NotificationHyperlink ... hyperlinks) {
        String title = String.format(FAILED_TO_SYNC_GRADLE_PROJECT_ERROR_GROUP_FORMAT, project.getName());
        AbstractSyncErrorHandler.updateNotification(notification, project, title, errorMsg, hyperlinks);
    }

    public static void updateNotification(NotificationData notification, Project project, String title, String errorMsg, NotificationHyperlink ... hyperlinks) {
        String text = errorMsg;
        int hyperlinkCount = hyperlinks.length;
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(hyperlinks[i].toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            text = text + '\n' + b.toString();
        }
        notification.setTitle(title);
        notification.setMessage(text);
        AbstractSyncErrorHandler.addNotificationListener(notification, project, hyperlinks);
    }

    protected static void addNotificationListener(NotificationData notification, final Project project, NotificationHyperlink ... hyperlinks) {
        for (final NotificationHyperlink hyperlink : hyperlinks) {
            notification.setListener(hyperlink.getUrl(), (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(Notification notification, HyperlinkEvent e) {
                    hyperlink.executeIfClicked(project, e);
                }
            });
        }
    }
}

