/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service;

import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.util.Facets;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Maps;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GradleModelDataService
implements ProjectDataService<GradleModel, Void> {
    private static final Logger LOG = Logger.getInstance(GradleModelDataService.class);

    public Key<GradleModel> getTargetDataKey() {
        return AndroidProjectKeys.GRADLE_MODEL;
    }

    public void importData(Collection<DataNode<GradleModel>> toImport, Project project, boolean synchronous) {
        if (!toImport.isEmpty()) {
            try {
                GradleModelDataService.doImport(toImport, project);
            }
            catch (Throwable e) {
                LOG.error(String.format("Failed to set up modules in project '%1$s'", project.getName()), e);
                GradleSyncState.getInstance(project).syncFailed(e.getMessage());
            }
        }
    }

    private static void doImport(final Collection<DataNode<GradleModel>> toImport, final Project project) throws Throwable {
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                if (!project.isDisposed()) {
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                    Map gradleProjectsByName = GradleModelDataService.indexByModuleName(toImport);
                    for (Module module : moduleManager.getModules()) {
                        GradleModel gradleModel = (GradleModel)gradleProjectsByName.get(module.getName());
                        if (gradleModel == null) {
                            Facets.removeAllFacetsOfType(module, AndroidGradleFacet.TYPE_ID);
                            continue;
                        }
                        String gradleVersion = gradleModel.getGradleVersion();
                        if (StringUtil.isNotEmpty((String)gradleVersion)) {
                            Projects.setGradleVersionUsed(project, gradleVersion);
                        }
                        GradleModelDataService.customizeModule(module, gradleModel);
                    }
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            throw error;
        }
    }

    private static Map<String, GradleModel> indexByModuleName(Collection<DataNode<GradleModel>> dataNodes) {
        HashMap gradleProjectsByModuleName = Maps.newHashMap();
        for (DataNode<GradleModel> d : dataNodes) {
            GradleModel gradleModel = (GradleModel)d.getData();
            gradleProjectsByModuleName.put(gradleModel.getModuleName(), gradleModel);
        }
        return gradleProjectsByModuleName;
    }

    private static void customizeModule(Module module, GradleModel gradleModel) {
        AndroidGradleFacet androidGradleFacet = GradleModelDataService.setAndGetAndroidGradleFacet(module);
        androidGradleFacet.setGradleModel(gradleModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AndroidGradleFacet setAndGetAndroidGradleFacet(Module module) {
        AndroidGradleFacet facet = AndroidGradleFacet.getInstance(module);
        if (facet != null) {
            return facet;
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        try {
            facet = (AndroidGradleFacet)facetManager.createFacet((FacetType)AndroidGradleFacet.getFacetType(), "Android-Gradle", null);
            model.addFacet((Facet)facet);
        }
        finally {
            model.commit();
        }
        return facet;
    }

    public void removeData(Collection<? extends Void> toRemove, Project project, boolean synchronous) {
    }
}

