/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.DeviceTarget;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GradleInvokerOptions {
    public final List<String> tasks;
    public final BuildMode buildMode;
    public final List<String> commandLineArguments;
    private static final String PROPERTY_BUILD_API = "android.injected.build.api";

    private GradleInvokerOptions(List<String> tasks, BuildMode buildMode, List<String> commandLineArguments) {
        this.tasks = tasks;
        this.buildMode = buildMode;
        this.commandLineArguments = commandLineArguments;
    }

    public static GradleInvokerOptions create(Project project, DataContext context, RunConfiguration configuration, ExecutionEnvironment env, String userGoal) {
        Collection<IDevice> devices = GradleInvokerOptions.getTargetDevices(env);
        List<String> cmdLineArgs = GradleInvokerOptions.getGradleArgumentsToTarget(devices);
        if (!StringUtil.isEmpty((String)userGoal)) {
            return new GradleInvokerOptions(Collections.singletonList(userGoal), null, cmdLineArgs);
        }
        Module[] modules = GradleInvokerOptions.getModules(project, context, configuration);
        if (MakeBeforeRunTaskProvider.isUnitTestConfiguration(configuration)) {
            Module[] affectedModules = GradleInvokerOptions.getAffectedModules(project, modules);
            BuildMode buildMode = BuildMode.COMPILE_JAVA;
            List<String> tasks = GradleInvoker.findTasksToExecute(affectedModules, buildMode, GradleInvoker.TestCompileType.JAVA_TESTS);
            return new GradleInvokerOptions(tasks, buildMode, cmdLineArgs);
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        GradleInvoker.TestCompileType testCompileType = GradleInvokerOptions.getTestCompileType(configuration);
        List<String> tasks = GradleInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        return new GradleInvokerOptions(tasks, buildMode, cmdLineArgs);
    }

    private static Module[] getModules(Project project, DataContext context, RunConfiguration configuration) {
        if (configuration instanceof ModuleRunProfile) {
            return ((ModuleRunProfile)configuration).getModules();
        }
        return Projects.getModulesToBuildFromSelection(project, context);
    }

    private static Module[] getAffectedModules(Project project, Module[] modules) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        CompileScope scope = compilerManager.createModulesCompileScope(modules, true, true);
        return scope.getAffectedModules();
    }

    private static GradleInvoker.TestCompileType getTestCompileType(RunConfiguration runConfiguration) {
        String id = runConfiguration != null ? runConfiguration.getType().getId() : null;
        return GradleInvoker.getTestCompileType(id);
    }

    private static List<String> getGradleArgumentsToTarget(Collection<IDevice> devices) {
        if (!devices.isEmpty()) {
            AndroidVersion min = null;
            for (IDevice device : devices) {
                AndroidVersion version = DevicePropertyUtil.getDeviceVersion(device);
                if (version == AndroidVersion.DEFAULT || min != null && version.getFeatureLevel() >= min.getFeatureLevel()) continue;
                min = version;
            }
            if (min != null) {
                String property = AndroidGradleSettings.createProjectProperty((String)PROPERTY_BUILD_API, (String)min.getApiString());
                return Collections.singletonList(property);
            }
        }
        return Collections.emptyList();
    }

    private static Collection<IDevice> getTargetDevices(ExecutionEnvironment env) {
        DeviceTarget deviceTarget = (DeviceTarget)env.getCopyableUserData(AndroidRunConfigurationBase.DEVICE_TARGET_KEY);
        if (deviceTarget == null) {
            return Collections.emptyList();
        }
        Collection<IDevice> readyDevices = deviceTarget.getDevicesIfReady();
        return readyDevices == null ? Collections.emptyList() : readyDevices;
    }
}

