/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.refactoring;

import com.android.tools.idea.gradle.dsl.dependencies.ModuleDependency;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GradleRenameModuleHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        return module != null && GradleRenameModuleHandler.getModuleRootDir(module) != null;
    }

    private static VirtualFile getModuleRootDir(Module module) {
        File moduleFilePath = new File(module.getModuleFilePath());
        return VfsUtil.findFileByIoFile((File)moduleFilePath.getParentFile(), (boolean)true);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(Project project, Editor editor, PsiFile file, DataContext dataContext) {
    }

    public void invoke(Project project, PsiElement[] elements, DataContext dataContext) {
        Module module = GradleRenameModuleHandler.getGradleModule(dataContext);
        assert (module != null);
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.module.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)module.getName(), (InputValidator)new MyInputValidator(module));
    }

    private static Module getGradleModule(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (module != null && (AndroidGradleFacet.getInstance(module) != null || Projects.isGradleProjectModule(module))) {
            return module;
        }
        return null;
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"rename.module.title");
    }

    private static void reset(List<GradleBuildModel> buildModels) {
        for (GradleBuildModel buildModel : buildModels) {
            buildModel.resetState();
        }
    }

    private static class MyInputValidator
    implements InputValidator {
        private final Module myModule;

        public MyInputValidator(Module module) {
            this.myModule = module;
        }

        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0 && !inputString.equals(this.myModule.getName()) && !inputString.contains(":");
        }

        public boolean canClose(final String inputString) {
            final Project project = this.myModule.getProject();
            final GradleSettingsFile settingsFile = GradleSettingsFile.get(project);
            if (settingsFile == null) {
                Messages.showErrorDialog((Project)project, (String)"settings.gradle file not found", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            final VirtualFile moduleRoot = GradleRenameModuleHandler.getModuleRootDir(this.myModule);
            assert (moduleRoot != null);
            if (Projects.isGradleProjectModule(this.myModule)) {
                Messages.showErrorDialog((Project)project, (String)"Can't rename root module", (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                return true;
            }
            String oldModuleGradlePath = GradleSettingsFile.getModuleGradlePath(this.myModule);
            if (oldModuleGradlePath == null) {
                return true;
            }
            final ArrayList modifiedBuildModels = Lists.newArrayList();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                if (buildModel == null) continue;
                for (ModuleDependency dependency : buildModel.dependencies().toModules()) {
                    if (!oldModuleGradlePath.equals(dependency.getPath())) continue;
                    dependency.setName(inputString);
                }
                if (!buildModel.isModified()) continue;
                modifiedBuildModels.add(buildModel);
            }
            String msg = IdeBundle.message((String)"command.renaming.module", (Object[])new Object[]{this.myModule.getName()});
            WriteCommandAction<Boolean> action = new WriteCommandAction<Boolean>(project, msg, new PsiFile[]{settingsFile.getPsiFile()}){

                protected void run(Result<Boolean> result) throws Throwable {
                    result.setResult((Object)true);
                    GrLiteral moduleReference = settingsFile.findModuleReference(MyInputValidator.this.myModule);
                    if (moduleReference == null) {
                        Messages.showErrorDialog((Project)project, (String)("Can't find module '" + MyInputValidator.this.myModule.getName() + "' in settings.gradle"), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    try {
                        moduleRoot.rename((Object)this, inputString);
                    }
                    catch (IOException e) {
                        Messages.showErrorDialog((Project)project, (String)("Rename folder failed: " + e.getMessage()), (String)IdeBundle.message((String)"title.rename.module", (Object[])new Object[0]));
                        result.setResult((Object)false);
                        GradleRenameModuleHandler.reset(modifiedBuildModels);
                        return;
                    }
                    moduleReference.updateText(moduleReference.getText().replace(MyInputValidator.this.myModule.getName(), inputString));
                    for (GradleBuildModel buildModel : modifiedBuildModels) {
                        buildModel.applyChanges();
                    }
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                        public void undo() throws UnexpectedUndoException {
                            GradleProjectImporter.getInstance().requestProjectSync(project, null);
                        }

                        public void redo() throws UnexpectedUndoException {
                            GradleProjectImporter.getInstance().requestProjectSync(project, null);
                        }
                    });
                    result.setResult((Object)true);
                }
            };
            if (((Boolean)action.execute().getResultObject()).booleanValue()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
                return true;
            }
            return false;
        }
    }
}

