/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.projectView;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ProjectViewNodeDecorator;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ColoredTreeCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;

public class ModuleNodeIconDecorator
implements ProjectViewNodeDecorator {
    public void decorate(ProjectViewNode node, PresentationData data) {
        if (!(node instanceof PsiDirectoryNode)) {
            return;
        }
        PsiDirectoryNode psiDirectoryNode = (PsiDirectoryNode)node;
        PsiDirectory psiDirectory = (PsiDirectory)psiDirectoryNode.getValue();
        Project project = psiDirectory.getProject();
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return;
        }
        VirtualFile folder = psiDirectory.getVirtualFile();
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(folder);
        if (module != null && ModuleNodeIconDecorator.isModuleFolder(folder, module)) {
            data.setIcon(GradleUtil.getModuleIcon(module));
        }
    }

    private static boolean isModuleFolder(VirtualFile folder, Module module) {
        VirtualFile moduleFile = module.getModuleFile();
        return moduleFile != null && folder.equals(moduleFile.getParent());
    }

    public void decorate(PackageDependenciesNode node, ColoredTreeCellRenderer cellRenderer) {
    }
}

