/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.library;

import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LibraryPropertiesDialog
extends DialogWrapper {
    private final Project myProject;
    private final Library myLibrary;
    private JPanel myMainPanel;
    private JPanel myTreePanel;
    private JBLabel myIconLabel;
    private JBLabel myNameLabel;
    private LibraryRootsComponent myLibraryEditorComponent;

    public LibraryPropertiesDialog(Project project, Library library) {
        super(project);
        this.myProject = project;
        this.myLibrary = library;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Library Properties");
    }

    protected JComponent createCenterPanel() {
        MultiLineLabel propertiesLabel;
        this.myIconLabel.setIcon(AllIcons.Modules.Library);
        this.myNameLabel.setText(this.myLibrary.getName());
        SourcesAndDocsOnlyEditor editor = new SourcesAndDocsOnlyEditor(this.myLibrary);
        this.myLibraryEditorComponent = new LibraryRootsComponent(this.myProject, (LibraryEditor)editor){

            public void updatePropertiesLabel() {
                MultiLineLabel propertiesLabel;
                JComponent c = this.getComponent();
                if (c != null && (propertiesLabel = (MultiLineLabel)UIUtil.findComponentOfType((JComponent)c, MultiLineLabel.class)) != null) {
                    propertiesLabel.setText("Add or remove source/Javadoc attachments");
                }
            }
        };
        this.myLibraryEditorComponent.updatePropertiesLabel();
        JComponent c = this.myLibraryEditorComponent.getComponent();
        List actionButtons = UIUtil.findComponentsOfType((JComponent)c, ActionButton.class);
        for (ActionButton actionButton : actionButtons) {
            String text = actionButton.getAction().getTemplatePresentation().getText();
            if (text == null || !text.startsWith("Exclude")) continue;
            actionButton.setVisible(false);
            break;
        }
        if ((propertiesLabel = (MultiLineLabel)UIUtil.findComponentOfType((JComponent)c, MultiLineLabel.class)) != null) {
            propertiesLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 1));
        }
        this.myTreePanel.add((Component)c, "Center");
        this.myTreePanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        return this.myMainPanel;
    }

    protected void dispose() {
        if (this.myLibraryEditorComponent != null) {
            Disposer.dispose((Disposable)this.myLibraryEditorComponent);
        }
        super.dispose();
    }

    protected void doOKAction() {
        this.save();
        super.doOKAction();
    }

    private void save() {
        if (this.myLibraryEditorComponent != null) {
            Projects.executeProjectChanges(this.myProject, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LibraryEditor editor = LibraryPropertiesDialog.this.myLibraryEditorComponent.getLibraryEditor();
                    Library.ModifiableModel libraryModel = LibraryPropertiesDialog.this.myLibrary.getModifiableModel();
                    try {
                        LibraryPropertiesDialog.addUrls(editor, libraryModel, OrderRootType.SOURCES);
                        LibraryPropertiesDialog.addUrls(editor, libraryModel, JavadocOrderRootType.getInstance());
                    }
                    finally {
                        libraryModel.commit();
                    }
                }
            });
        }
    }

    private static void addUrls(LibraryEditor editor, Library.ModifiableModel libraryModel, OrderRootType type) {
        HashSet existingUrls = Sets.newHashSet((Object[])libraryModel.getUrls(type));
        for (String url : editor.getUrls(type)) {
            if (existingUrls.contains(url)) continue;
            libraryModel.addRoot(url, type);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(600, 400), null));
        this.myIconLabel = jBLabel2 = new JBLabel();
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 1, null, null, null));
        this.myNameLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class SourcesAndDocsOnlyEditor
    extends ExistingLibraryEditor {
        SourcesAndDocsOnlyEditor(Library library) {
            super(library, null);
        }

        public String[] getUrls(OrderRootType rootType) {
            if (SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            return super.getUrls(rootType);
        }

        public void addRoot(VirtualFile file, OrderRootType rootType) {
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.addRoot(file, rootType);
            }
        }

        public void addRoot(String url, OrderRootType rootType) {
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.addRoot(url, rootType);
            }
        }

        public void removeRoot(String url, OrderRootType rootType) {
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.removeRoot(url, rootType);
            }
        }

        private static boolean isIgnored(OrderRootType rootType) {
            return rootType == OrderRootType.CLASSES;
        }
    }
}

