/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.PreciseRevision;
import com.google.common.base.Splitter;
import java.util.List;

class VersionRange {
    private static final char OR_GREATER = '+';
    private static final char START_INCLUSIVE = '[';
    private static final char START_EXCLUSIVE = '(';
    private static final char END_INCLUSIVE = ']';
    private static final char END_EXCLUSIVE = ')';
    private final String myMinVersion;
    private final FullRevision myMinRevision;
    private final boolean myMinVersionInclusive;
    private final FullRevision myMaxRevision;
    private final String myMaxVersion;
    private final boolean myMaxVersionInclusive;

    static VersionRange parse(String value) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Empty string is not a valid value");
        }
        int size = value.length();
        char lastChar = value.charAt(size - 1);
        if (lastChar == '+') {
            String minVersion = value.substring(0, size - 1);
            return new VersionRange(minVersion, true, null, false);
        }
        char firstChar = value.charAt(0);
        if (firstChar == '[' || firstChar == '(') {
            boolean minVersionInclusive;
            boolean bl = minVersionInclusive = firstChar == '[';
            if (lastChar != ']' && lastChar != ')') {
                throw new IllegalArgumentException(String.format("Value '%1$s' should end with ']' or ')'", value));
            }
            boolean maxVersionInclusive = lastChar == ']';
            String rangeValue = value.substring(1, size - 1);
            List values = Splitter.on((char)',').splitToList((CharSequence)rangeValue);
            if (values.size() != 2) {
                throw new IllegalArgumentException(String.format("Range '%1$s' should contain 2 values", value));
            }
            String minVersion = ((String)values.get(0)).trim();
            String maxVersion = ((String)values.get(1)).trim();
            if (maxVersion.length() == 1 && maxVersion.charAt(0) == '+') {
                maxVersion = null;
            }
            return new VersionRange(minVersion, minVersionInclusive, maxVersion, maxVersionInclusive);
        }
        return new VersionRange(value, false, null, false);
    }

    private VersionRange(String minVersion, boolean minVersionInclusive, String maxVersion, boolean maxVersionInclusive) {
        this.myMinVersion = minVersion;
        this.myMinRevision = VersionRange.asRevision(minVersion);
        this.myMinVersionInclusive = minVersionInclusive;
        this.myMaxVersion = maxVersion;
        this.myMaxRevision = VersionRange.asRevision(maxVersion);
        this.myMaxVersionInclusive = maxVersionInclusive;
    }

    boolean contains(String value) {
        if (this.myMinRevision != null) {
            boolean contains = false;
            FullRevision revision = VersionRange.asRevision(value);
            if (revision != null) {
                if (this.myMinVersionInclusive) {
                    contains = revision.compareTo(this.myMinRevision, FullRevision.PreviewComparison.IGNORE) >= 0;
                } else {
                    boolean bl = contains = revision.compareTo(this.myMinRevision, FullRevision.PreviewComparison.IGNORE) > 0;
                }
                if (contains && this.myMaxRevision != null) {
                    contains = this.myMaxVersionInclusive ? revision.compareTo(this.myMaxRevision, FullRevision.PreviewComparison.IGNORE) <= 0 : revision.compareTo(this.myMaxRevision, FullRevision.PreviewComparison.IGNORE) < 0;
                }
            }
            return contains;
        }
        return value.equals(this.myMinVersion) || value.equals(this.myMaxVersion);
    }

    private static FullRevision asRevision(String version) {
        if (version != null) {
            try {
                return PreciseRevision.parseRevision((String)version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    String getDescription() {
        if (this.myMinVersion.equals(this.myMaxVersion)) {
            return this.myMinVersion;
        }
        if (this.myMaxVersion == null) {
            return String.format("%1$s (or newer)", this.myMinVersion);
        }
        return "versions " + this.myMinVersion + VersionRange.inclusiveness(this.myMinVersionInclusive) + " to " + this.myMaxVersion + VersionRange.inclusiveness(this.myMaxVersionInclusive);
    }

    private static String inclusiveness(boolean inclusive) {
        return "(" + (inclusive ? "inclusive" : "exclusive") + ")";
    }
}

