/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.project.compatibility.BuildFileComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.ComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.FileLocation;
import com.android.tools.idea.gradle.project.compatibility.VersionRange;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class VersionCompatibilityService {
    private static Logger LOG = Logger.getInstance(VersionCompatibilityService.class);
    private static final String BUILD_FILE_PREFIX = "buildFile:";
    private static final String METADATA_FILE_NAME = "android-component-compatibility.xml";
    private VersionMetadata myMetadata = new VersionMetadata(1);

    public static VersionCompatibilityService getInstance() {
        return (VersionCompatibilityService)ServiceManager.getService(VersionCompatibilityService.class);
    }

    public VersionCompatibilityService() {
        this.reloadMetadata();
    }

    @VisibleForTesting
    public void reloadMetadata() {
        File metadataFilePath = VersionCompatibilityService.getMetadataFilePath();
        if (metadataFilePath.isFile()) {
            try {
                Element root = JDOMUtil.load((File)metadataFilePath);
                this.myMetadata = VersionCompatibilityService.loadMetadata(root);
            }
            catch (Throwable e) {
                LOG.info("Failed to load/parse file '" + metadataFilePath.getPath() + "'. Loading metadata from local file.", e);
                this.loadLocalMetadata();
            }
        } else {
            this.loadLocalMetadata();
        }
    }

    @VisibleForTesting
    public void reloadMetadataForTesting(@Language(value="XML") String metadata) throws JDOMException, IOException {
        Element root = JDOMUtil.load((Reader)new StringReader(metadata));
        this.myMetadata = VersionCompatibilityService.loadMetadata(root);
    }

    boolean updateMetadata(Document metadata) {
        try {
            VersionMetadata updated = VersionCompatibilityService.loadMetadata(metadata.getRootElement());
            if (updated.dataVersion > this.myMetadata.dataVersion) {
                this.myMetadata = updated;
                File metadataFilePath = VersionCompatibilityService.getMetadataFilePath();
                JDOMUtil.writeDocument((Document)metadata, (File)metadataFilePath, (String)SystemProperties.getLineSeparator());
                LOG.info("Saved component version metadata to: " + metadataFilePath);
                return true;
            }
        }
        catch (Throwable e) {
            LOG.info("Failed to update component version metadata", e);
        }
        return false;
    }

    @VisibleForTesting
    public static File getMetadataFilePath() {
        File configPath = new File(FileUtil.toSystemDependentName((String)PathManager.getConfigPath()));
        return new File(configPath, METADATA_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalMetadata() {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream(METADATA_FILE_NAME);
            Element root = JDOMUtil.load((InputStream)inputStream);
            this.myMetadata = VersionCompatibilityService.loadMetadata(root);
        }
        catch (Throwable e) {
            LOG.info("Failed to load/parse local metadata file.", e);
        }
        finally {
            try {
                Closeables.close((Closeable)inputStream, (boolean)true);
            }
            catch (IOException ignored) {}
        }
    }

    private static VersionMetadata loadMetadata(Element root) {
        String dataVersionText = root.getAttributeValue("version");
        int dataVersion = 1;
        try {
            dataVersion = Integer.parseInt(dataVersionText);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        VersionMetadata metadata = new VersionMetadata(dataVersion);
        for (Element checkElement : root.getChildren("check")) {
            Element componentElement = checkElement.getChild("component");
            ComponentVersion version = VersionCompatibilityService.createComponentVersion(componentElement, metadata);
            for (Element requirementElement : componentElement.getChildren("requires")) {
                version.requirements.add(VersionCompatibilityService.createComponentVersion(requirementElement, metadata));
            }
            String type = checkElement.getAttributeValue("failureType");
            CompatibilityCheck check = new CompatibilityCheck(version, VersionCompatibilityService.getFailureType(type));
            metadata.compatibilityChecks.add(check);
        }
        return metadata;
    }

    private static Message.Type getFailureType(String value) {
        Message.Type type = Message.Type.find(value);
        return type != null ? type : Message.Type.ERROR;
    }

    private static ComponentVersion createComponentVersion(Element xmlElement, VersionMetadata metadata) {
        String name = xmlElement.getAttribute("name").getValue();
        if (name.startsWith(BUILD_FILE_PREFIX)) {
            name = name.substring(BUILD_FILE_PREFIX.length());
            ComponentVersionReader reader = (ComponentVersionReader)metadata.versionReadersByComponentName.get(name);
            if (reader == null) {
                metadata.versionReadersByComponentName.put(name, new BuildFileComponentVersionReader(name));
            }
        }
        String version = xmlElement.getAttributeValue("version");
        String failureMsg = null;
        Element failureMsgElement = xmlElement.getChild("failureMsg");
        if (failureMsgElement != null) {
            failureMsg = Strings.emptyToNull((String)failureMsgElement.getTextNormalize());
        }
        return new ComponentVersion(name, version, failureMsg);
    }

    public List<VersionIncompatibilityMessage> checkComponentCompatibility(Project project) {
        CompatibilityChecker checker = new CompatibilityChecker(project, this.myMetadata);
        return checker.execute();
    }

    public static class VersionIncompatibilityMessage {
        private final Message myMessage;
        private final NotificationHyperlink[] myQuickFixes;

        VersionIncompatibilityMessage(Message message, List<NotificationHyperlink> quickFixes) {
            this.myMessage = message;
            this.myQuickFixes = quickFixes.toArray(new NotificationHyperlink[quickFixes.size()]);
        }

        public Message getMessage() {
            return this.myMessage;
        }

        public NotificationHyperlink[] getQuickFixes() {
            return this.myQuickFixes;
        }
    }

    private static class ComponentVersion {
        final String componentName;
        final VersionRange versionRange;
        final String failureMsg;
        final List<ComponentVersion> requirements = Lists.newArrayList();

        ComponentVersion(String componentName, String version, String failureMsg) {
            this.componentName = componentName;
            this.versionRange = VersionRange.parse(version);
            this.failureMsg = failureMsg;
        }

        private static class Incompatibility {
            final Module module;
            final CompatibilityCheck compatibilityCheck;
            final Pair<ComponentVersionReader, String> readerAndVersion;
            final ComponentVersion requirement;
            final ComponentVersionReader requirementVersionReader;
            final List<String> messages = Lists.newArrayList();

            Incompatibility(Module module, CompatibilityCheck compatibilityCheck, Pair<ComponentVersionReader, String> readerAndVersion, ComponentVersion requirement, ComponentVersionReader requirementVersionReader) {
                this.module = module;
                this.compatibilityCheck = compatibilityCheck;
                this.readerAndVersion = readerAndVersion;
                this.requirement = requirement;
                this.requirementVersionReader = requirementVersionReader;
            }
        }
    }

    private static class CompatibilityCheck {
        final ComponentVersion myComponentVersion;
        final Message.Type failureType;

        CompatibilityCheck(ComponentVersion componentVersion, Message.Type failureType) {
            this.myComponentVersion = componentVersion;
            this.failureType = failureType;
        }
    }

    private static class VersionMetadata {
        final int dataVersion;
        private final List<CompatibilityCheck> compatibilityChecks = Lists.newArrayList();
        private final Map<String, ComponentVersionReader> versionReadersByComponentName = Maps.newConcurrentMap();

        VersionMetadata(int dataVersion) {
            this.dataVersion = dataVersion;
            this.versionReadersByComponentName.put("gradle", ComponentVersionReader.GRADLE);
            this.versionReadersByComponentName.put("android-gradle-plugin", ComponentVersionReader.ANDROID_GRADLE_PLUGIN);
            if (AndroidStudioInitializer.isAndroidStudio()) {
                this.versionReadersByComponentName.put("android-studio", ComponentVersionReader.IDE);
            } else if (PlatformUtils.isIntelliJ()) {
                this.versionReadersByComponentName.put("idea", ComponentVersionReader.IDE);
            }
        }
    }

    private static class CompatibilityChecker {
        private final Project myProject;
        private final VersionMetadata myMetadata;
        private final Map<String, Pair<ComponentVersionReader, String>> myProjectComponentVersionCache = Maps.newHashMap();
        private final Map<String, Map<String, Pair<ComponentVersionReader, String>>> myModuleComponentVersionCache = Maps.newHashMap();

        CompatibilityChecker(Project project, VersionMetadata metadata) {
            this.myProject = project;
            this.myMetadata = metadata;
        }

        List<VersionIncompatibilityMessage> execute() {
            Module[] modules;
            HashMap incompatibilitiesByCheck = Maps.newHashMap();
            for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                for (CompatibilityCheck check : this.myMetadata.compatibilityChecks) {
                    String version;
                    ComponentVersion componentVersion = check.myComponentVersion;
                    Pair<ComponentVersionReader, String> readerAndVersion = this.getComponentVersion(componentVersion, module);
                    if (readerAndVersion == null || !componentVersion.versionRange.contains(version = (String)readerAndVersion.getSecond())) continue;
                    for (ComponentVersion requirement : componentVersion.requirements) {
                        String msg;
                        String requirementVersion;
                        Pair<ComponentVersionReader, String> readerAndRequirementVersion = this.getComponentVersion(requirement, module);
                        if (readerAndRequirementVersion == null || requirement.versionRange.contains(requirementVersion = (String)readerAndRequirementVersion.getSecond())) continue;
                        boolean projectLevelCheck = ((ComponentVersionReader)readerAndVersion.getFirst()).isProjectLevel();
                        String id = projectLevelCheck ? check.myComponentVersion.componentName : module.getName() + "." + check.myComponentVersion.componentName;
                        ComponentVersion.Incompatibility incompatibility = (ComponentVersion.Incompatibility)incompatibilitiesByCheck.get(id);
                        if (incompatibility == null) {
                            ComponentVersionReader requirementVersionReader = (ComponentVersionReader)readerAndRequirementVersion.getFirst();
                            incompatibility = new ComponentVersion.Incompatibility(module, check, readerAndVersion, requirement, requirementVersionReader);
                            incompatibilitiesByCheck.put(id, incompatibility);
                        }
                        if (((ComponentVersionReader)readerAndRequirementVersion.getFirst()).isProjectLevel()) {
                            if (!incompatibility.messages.isEmpty()) continue;
                            msg = String.format(" but project is using version %1$s.", requirementVersion);
                            incompatibility.messages.add(msg);
                            continue;
                        }
                        msg = String.format("Module '%1$s' is using version %2$s", module.getName(), requirementVersion);
                        incompatibility.messages.add(msg);
                    }
                }
            }
            if (incompatibilitiesByCheck.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList failureMessages = Lists.newArrayList();
            for (ComponentVersion.Incompatibility incompatibility : incompatibilitiesByCheck.values()) {
                CompatibilityCheck check = incompatibility.compatibilityCheck;
                Pair<ComponentVersionReader, String> readerAndVersion = incompatibility.readerAndVersion;
                ComponentVersionReader reader = (ComponentVersionReader)readerAndVersion.getFirst();
                String componentName = reader.getComponentName();
                String version = (String)readerAndVersion.getSecond();
                ComponentVersionReader requirementVersionReader = incompatibility.requirementVersionReader;
                String requirementComponentName = requirementVersionReader.getComponentName();
                StringBuilder msg = new StringBuilder();
                msg.append(componentName).append(" ").append(version);
                Module module = incompatibility.module;
                FileLocation location = reader.getVersionSource(module);
                if (!reader.isProjectLevel() && location == null) {
                    msg.append(", in module '").append(module.getName()).append(",'");
                }
                msg.append(" requires ").append(requirementComponentName).append(" ");
                ComponentVersion requirement = incompatibility.requirement;
                VersionRange requirementVersionRange = requirement.versionRange;
                msg.append(requirementVersionRange.getDescription());
                List<String> messages = incompatibility.messages;
                if (messages.size() == 1) {
                    msg.append(" ").append(messages.get(0));
                } else {
                    msg.append("<ul>");
                    for (String message : messages) {
                        msg.append("<li>").append(message).append("</li>");
                    }
                    msg.append("</ul>");
                }
                String group = "Gradle Sync Issue";
                Message.Type failureType = check.failureType;
                ArrayList textLines = Lists.newArrayList();
                textLines.add(msg.toString());
                String failureMsg = requirement.failureMsg;
                if (failureMsg != null) {
                    List lines = Splitter.on((String)"\\n").omitEmptyStrings().splitToList((CharSequence)failureMsg);
                    textLines.addAll(lines);
                }
                String[] text = ArrayUtil.toStringArray((Collection)textLines);
                Message message = location != null ? new Message(this.myProject, group, failureType, location.file, location.lineNumber, location.column, text) : new Message(group, failureType, text);
                ArrayList quickFixes = Lists.newArrayList();
                quickFixes.addAll(reader.getQuickFixes(module, null, null));
                quickFixes.addAll(requirementVersionReader.getQuickFixes(module, requirementVersionRange, location));
                failureMessages.add(new VersionIncompatibilityMessage(message, quickFixes));
            }
            return failureMessages;
        }

        private Pair<ComponentVersionReader, String> getComponentVersion(ComponentVersion componentVersion, Module module) {
            Map<String, Pair<ComponentVersionReader, String>> componentVersionsByModule;
            String componentName = componentVersion.componentName;
            Pair readerAndVersion = this.myProjectComponentVersionCache.get(componentName);
            if (readerAndVersion == null && (componentVersionsByModule = this.myModuleComponentVersionCache.get(componentName)) != null) {
                readerAndVersion = componentVersionsByModule.get(module.getName());
            }
            if (readerAndVersion == null) {
                ComponentVersionReader reader = (ComponentVersionReader)this.myMetadata.versionReadersByComponentName.get(componentName);
                if (reader == null) {
                    LOG.info(String.format("Failed to find version reader for component '%1$s'", componentName));
                    return null;
                }
                if (!reader.appliesTo(module)) {
                    return null;
                }
                String version = reader.getComponentVersion(module);
                if (version != null) {
                    readerAndVersion = Pair.create((Object)reader, (Object)version);
                    if (reader.isProjectLevel()) {
                        this.myProjectComponentVersionCache.put(componentName, (Pair<ComponentVersionReader, String>)readerAndVersion);
                    } else {
                        HashMap componentVersionsByModule2 = this.myModuleComponentVersionCache.get(componentName);
                        if (componentVersionsByModule2 == null) {
                            componentVersionsByModule2 = Maps.newHashMap();
                            this.myModuleComponentVersionCache.put(componentName, componentVersionsByModule2);
                        }
                        componentVersionsByModule2.put(module.getName(), readerAndVersion);
                    }
                } else {
                    Project project = module.getProject();
                    String msg = String.format("Failed to read version for component '%1$s'", componentName);
                    msg = reader.isProjectLevel() ? msg + String.format(" for project '%1$s'", project.getName()) : msg + String.format(" for module '%1$s', in project '%2$s'", module.getName(), project.getName());
                    LOG.info(msg);
                }
            }
            return readerAndVersion;
        }
    }
}

