/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.compatibility;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.project.compatibility.ComponentVersionReader;
import com.android.tools.idea.gradle.project.compatibility.FileLocation;
import com.android.tools.idea.gradle.project.compatibility.VersionRange;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixGradleModelVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.module.Module;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;

class AndroidGradlePluginVersionReader
implements ComponentVersionReader {
    AndroidGradlePluginVersionReader() {
    }

    @Override
    public boolean appliesTo(Module module) {
        return AndroidFacet.getInstance(module) != null;
    }

    @Override
    public String getComponentVersion(Module module) {
        AndroidGradleModel androidModel;
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null && (androidModel = AndroidGradleModel.get(facet)) != null) {
            return androidModel.getAndroidProject().getModelVersion();
        }
        return null;
    }

    @Override
    public FileLocation getVersionSource(Module module) {
        return null;
    }

    @Override
    public List<NotificationHyperlink> getQuickFixes(Module module, VersionRange expectedVersion, FileLocation location) {
        String version = "1.5.0";
        if (expectedVersion != null && expectedVersion.contains(version)) {
            FixGradleModelVersionHyperlink quickFix = new FixGradleModelVersionHyperlink(version, null, false);
            return Collections.singletonList(quickFix);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    public String getComponentName() {
        return "Android Gradle plugin";
    }
}

