/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.util.Projects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    private static final Logger LOG = Logger.getInstance(ProjectSetUpTask.class);
    private final Project myProject;
    private final boolean myProjectIsNew;
    private final boolean mySelectModulesToImport;
    private final boolean mySyncSkipped;
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(Project project, boolean projectIsNew, boolean selectModulesToImport, boolean syncSkipped, GradleSyncListener syncListener) {
        this.myProject = project;
        this.myProjectIsNew = projectIsNew;
        this.mySelectModulesToImport = selectModulesToImport;
        this.mySyncSkipped = syncSkipped;
        this.mySyncListener = syncListener;
    }

    public void onSuccess(DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        this.populateProject(projectInfo);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
                if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                    if (ProjectSetUpTask.this.myProjectIsNew) {
                        Projects.open(ProjectSetUpTask.this.myProject);
                    }
                    if (!isTest) {
                        ProjectSetUpTask.this.myProject.save();
                    }
                }
                if (ProjectSetUpTask.this.myProjectIsNew) {
                    AndroidGradleProjectComponent projectComponent = (AndroidGradleProjectComponent)((Object)ServiceManager.getService((Project)ProjectSetUpTask.this.myProject, AndroidGradleProjectComponent.class));
                    projectComponent.configureGradleProject();
                }
                if (ProjectSetUpTask.this.mySyncListener != null) {
                    if (ProjectSetUpTask.this.mySyncSkipped) {
                        ProjectSetUpTask.this.mySyncListener.syncSkipped(ProjectSetUpTask.this.myProject);
                    } else {
                        ProjectSetUpTask.this.mySyncListener.syncSucceeded(ProjectSetUpTask.this.myProject);
                    }
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        }
    }

    private void populateProject(final DataNode<ProjectData> projectInfo) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                Projects.populate(ProjectSetUpTask.this.myProject, ProjectSetUpTask.this.getModulesToImport((DataNode<ProjectData>)projectInfo));
            }
        });
    }

    private Collection<DataNode<ModuleData>> getModulesToImport(DataNode<ProjectData> projectInfo) {
        Collection modules = ExternalSystemApiUtil.findAll(projectInfo, (Key)ProjectKeys.MODULE);
        ProjectSubset subview = ProjectSubset.getInstance(this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode() && ProjectSubset.isSettingEnabled() && modules.size() > 1) {
            if (this.mySelectModulesToImport) {
                Collection<DataNode<ModuleData>> selection = subview.showModuleSelectionDialog(modules);
                if (selection != null) {
                    return selection;
                }
            } else {
                int moduleCount;
                Object[] persistedModuleNames = subview.getSelection();
                if (persistedModuleNames != null && (moduleCount = persistedModuleNames.length) > 0) {
                    ArrayList moduleNames = Lists.newArrayList((Object[])persistedModuleNames);
                    ArrayList selectedModules = Lists.newArrayListWithExpectedSize((int)moduleCount);
                    for (DataNode module : modules) {
                        String name = ((ModuleData)module.getData()).getExternalName();
                        if (!moduleNames.contains(name)) continue;
                        selectedModules.add(module);
                    }
                    return selectedModules;
                }
            }
        }
        subview.clearSelection();
        return modules;
    }

    public void onFailure(String errorMessage, String errorDetails) {
        if (errorDetails != null) {
            LOG.warn(errorDetails);
        }
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        LOG.info(newMessage);
        GradleProjectSyncData.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }
}

