/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.stats.UsageTracker;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class ProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    public static final String GRADLE_DSL_METHOD_NOT_FOUND_ERROR_PREFIX = "Gradle DSL method not found";
    public static final String CONNECTION_PERMISSION_DENIED_PREFIX = "Connection to the Internet denied.";
    public static final String INSTALL_ANDROID_SUPPORT_REPO = "Please install the Android Support Repository from the Android SDK Manager.";
    private static final Pattern SDK_NOT_FOUND_PATTERN = Pattern.compile("The SDK directory '(.*?)' does not exist.");
    private static final Pattern CLASS_NOT_FOUND_PATTERN = Pattern.compile("(.+) not found.");
    private static final String EMPTY_LINE = "\n\n";
    private static final String UNSUPPORTED_GRADLE_VERSION_ERROR = "Gradle version 2.2.1 is required";
    private static final String SDK_DIR_PROPERTY_MISSING = "No sdk.dir property defined in local.properties file.";
    private static final Pattern ERROR_LOCATION_PATTERN = Pattern.compile(".* file '(.*)'( line: ([\\d]+))?");

    public ExternalSystemException getUserFriendlyError(Throwable error, String projectPath, String buildFilePath) {
        String msg;
        String message;
        if (error instanceof ExternalSystemException) {
            ProjectImportErrorHandler.trackSyncError(error);
            return (ExternalSystemException)error;
        }
        Pair rootCauseAndLocation = this.getRootCauseAndLocation(error);
        Throwable rootCause = (Throwable)rootCauseAndLocation.getFirst();
        if (ProjectImportErrorHandler.isOldGradleVersion(rootCause)) {
            ProjectImportErrorHandler.trackSyncError("syncFailedUnsupportedGradleVersion");
            String msg2 = "The project is using an unsupported version of Gradle.\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            return this.createUserFriendlyError(msg2, null, new String[0]);
        }
        String rootCauseText = rootCause.toString();
        if (StringUtil.startsWith((CharSequence)rootCauseText, (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
            String method = this.parseMissingMethod(rootCauseText);
            ProjectImportErrorHandler.trackSyncError("syncFailedDslMethodNotFound", method);
            return this.createUserFriendlyError("Gradle DSL method not found: '" + method + "'", (String)rootCauseAndLocation.getSecond(), new String[0]);
        }
        if (rootCause instanceof SocketException && (message = rootCause.getMessage()) != null && message.contains("Permission denied: connect")) {
            ProjectImportErrorHandler.trackSyncError("syncFailedConnectionDenied");
            return this.createUserFriendlyError(CONNECTION_PERMISSION_DENIED_PREFIX, null, new String[0]);
        }
        if (rootCause instanceof UnknownHostException) {
            ProjectImportErrorHandler.trackSyncError("syncFailedUnknownHost");
            msg = String.format("Unknown host '%1$s'. You may need to adjust the proxy settings in Gradle.", rootCause.getMessage());
            return this.createUserFriendlyError(msg, null, new String[0]);
        }
        if ((rootCause instanceof IllegalStateException || rootCause instanceof ExternalSystemException) && (msg = rootCause.getMessage()) != null) {
            if (msg.startsWith("failed to find target android-")) {
                ProjectImportErrorHandler.trackSyncError("syncFailedMissingAndroidPlatform");
                return this.createUserFriendlyError(msg, null, new String[0]);
            }
            if (msg.startsWith("failed to find Build Tools")) {
                ProjectImportErrorHandler.trackSyncError("syncFailedMissingBuildTools");
                return this.createUserFriendlyError(msg, null, new String[0]);
            }
        }
        if (rootCause instanceof RuntimeException) {
            msg = rootCause.getMessage();
            if (msg != null && msg.contains("Could not find") && msg.contains("com.android.support:")) {
                ProjectImportErrorHandler.trackSyncError("syncFailedMissingAndroidSupportRepo");
                String newMsg = msg + EMPTY_LINE + INSTALL_ANDROID_SUPPORT_REPO;
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
            if (msg != null && msg.contains("failed to parse SDK")) {
                ProjectImportErrorHandler.trackSyncError("syncFailedCannotParseSdk");
                String newMsg = msg + EMPTY_LINE + "The Android SDK may be missing the directory 'add-ons'.";
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
            if (msg != null && (msg.equals(SDK_DIR_PROPERTY_MISSING) || SDK_NOT_FOUND_PATTERN.matcher(msg).matches())) {
                ProjectImportErrorHandler.trackSyncError("syncFailedSdkNotFound");
                String newMsg = msg;
                File buildProperties = new File(projectPath, "local.properties");
                if (buildProperties.isFile()) {
                    newMsg = newMsg + "\n\nPlease fix the 'sdk.dir' property in the local.properties file.";
                }
                return this.createUserFriendlyError(newMsg, null, new String[0]);
            }
        }
        if (rootCause instanceof OutOfMemoryError) {
            ProjectImportErrorHandler.trackSyncError("syncFailedOutOfMemory");
            String originalMessage = rootCause.getMessage();
            String msg3 = "Out of memory";
            if (originalMessage != null && !originalMessage.isEmpty()) {
                msg3 = msg3 + ": " + originalMessage;
            }
            return this.createUserFriendlyError(msg3, null, new String[0]);
        }
        if (rootCause instanceof NoSuchMethodError) {
            String methodName = rootCause.getMessage();
            ProjectImportErrorHandler.trackSyncError("syncFailedMethodNotFound", methodName);
            String msg4 = String.format("Unable to find method '%1$s'.", methodName);
            return this.createUserFriendlyError(msg4, null, new String[0]);
        }
        if (rootCause instanceof ClassNotFoundException) {
            String className = rootCause.getMessage();
            ProjectImportErrorHandler.trackSyncError("syncFailedClassNotFound", className);
            Matcher matcher = CLASS_NOT_FOUND_PATTERN.matcher(className);
            if (matcher.matches()) {
                className = matcher.group(1);
            }
            String msg5 = String.format("Unable to load class '%1$s'.", className);
            return this.createUserFriendlyError(msg5, null, new String[0]);
        }
        return null;
    }

    private static boolean isOldGradleVersion(Throwable error) {
        String msg;
        if (error instanceof UnsupportedVersionException) {
            return true;
        }
        if (error instanceof UnsupportedMethodException && (msg = error.getMessage()) != null && msg.contains("GradleProject.getBuildScript")) {
            return true;
        }
        if (error instanceof ClassNotFoundException && (msg = error.getMessage()) != null && msg.contains(ToolingModelBuilderRegistry.class.getName())) {
            return true;
        }
        return error instanceof RuntimeException && (msg = error.getMessage()) != null && msg.startsWith(UNSUPPORTED_GRADLE_VERSION_ERROR);
    }

    static void trackSyncError(String errorType) {
        ProjectImportErrorHandler.trackSyncError(errorType, null);
    }

    static void trackSyncError(Throwable error) {
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)error);
        ProjectImportErrorHandler.trackSyncError("syncFailedCauseUnknown", rootCause.getClass().getName());
    }

    static void trackSyncError(String errorType, String extraInfo) {
        UsageTracker.getInstance().trackEvent("gradleSyncFailure", errorType, extraInfo, null);
    }

    public String getLocationFrom(Throwable error) {
        String location;
        String errorToString = error.toString();
        if (errorToString.contains("LocationAwareException") && (location = error.getMessage()) != null && (location.startsWith("Build file '") || location.startsWith("Settings file '"))) {
            String[] lines = StringUtil.splitByLines((String)location);
            return lines.length > 0 ? lines[0] : null;
        }
        return null;
    }

    public ExternalSystemException createUserFriendlyError(String msg, String location, String ... quickFixes) {
        Pair<String, Integer> pair;
        if (StringUtil.isNotEmpty((String)location) && (pair = ProjectImportErrorHandler.getErrorLocation(location)) != null) {
            return new LocationAwareExternalSystemException(msg, (String)pair.first, (Integer)pair.getSecond(), quickFixes);
        }
        return new ExternalSystemException(msg, null, quickFixes);
    }

    @VisibleForTesting
    static Pair<String, Integer> getErrorLocation(String location) {
        Matcher matcher = ERROR_LOCATION_PATTERN.matcher(location);
        if (matcher.matches()) {
            String filePath = matcher.group(1);
            int line = -1;
            String lineAsText = matcher.group(3);
            if (lineAsText != null) {
                try {
                    line = Integer.parseInt(lineAsText);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return Pair.create((Object)filePath, (Object)line);
        }
        return null;
    }
}

