/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LibraryAttachments {
    static final List<OrderRootType> SUPPORTED_TYPES = Lists.newArrayList((Object[])new OrderRootType[]{OrderRootType.SOURCES, JavadocOrderRootType.getInstance()});
    private static final Key<LibraryAttachments> LIBRARY_ATTACHMENTS = Key.create((String)"project.library.attachments");
    private final Project myProject;
    private final Map<OrderRootType, Map<String, List<String>>> myAttachmentsByType;

    public static LibraryAttachments getStoredLibraryAttachments(Project project) {
        return (LibraryAttachments)project.getUserData(LIBRARY_ATTACHMENTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLibrariesAndStoreAttachments(Project project) {
        LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
        LibraryTable.ModifiableModel model = libraryTable.getModifiableModel();
        try {
            HashMap attachmentsByType = Maps.newHashMap();
            for (Library library : model.getLibraries()) {
                for (OrderRootType type : SUPPORTED_TYPES) {
                    String name;
                    Map attachmentsByLibrary = (Map)attachmentsByType.get(type);
                    if (attachmentsByLibrary == null) {
                        attachmentsByLibrary = Maps.newHashMap();
                        attachmentsByType.put(type, attachmentsByLibrary);
                    }
                    if ((name = library.getName()) != null) {
                        List attachments = (List)attachmentsByLibrary.get(name);
                        if (attachments == null) {
                            attachments = Lists.newArrayList();
                            attachmentsByLibrary.put(name, attachments);
                        }
                        String[] urls = library.getUrls(type);
                        Collections.addAll(attachments, urls);
                    }
                    attachmentsByType.put(type, attachmentsByLibrary);
                }
                model.removeLibrary(library);
            }
            LibraryAttachments attachments = new LibraryAttachments(project, attachmentsByType);
            project.putUserData(LIBRARY_ATTACHMENTS, (Object)attachments);
        }
        finally {
            model.commit();
        }
    }

    private LibraryAttachments(Project project, Map<OrderRootType, Map<String, List<String>>> attachmentsByType) {
        this.myProject = project;
        this.myAttachmentsByType = attachmentsByType;
    }

    public void addUrlsTo(Library.ModifiableModel libraryModel) {
        for (OrderRootType type : this.myAttachmentsByType.keySet()) {
            List<String> attachments;
            Map<String, List<String>> attachmentsByLibrary = this.myAttachmentsByType.get(type);
            if (attachmentsByLibrary == null || (attachments = attachmentsByLibrary.get(libraryModel.getName())) == null) continue;
            LibraryAttachments.addUrlsToLibrary(type, libraryModel, attachments);
        }
    }

    private static void addUrlsToLibrary(OrderRootType type, Library.ModifiableModel libraryModel, Collection<String> urls) {
        if (!urls.isEmpty()) {
            HashSet existing = Sets.newHashSet((Object[])libraryModel.getUrls(type));
            for (String url : urls) {
                if (existing.contains(url)) continue;
                libraryModel.addRoot(url, type);
            }
        }
    }

    public void removeFromProject() {
        this.myProject.putUserData(LIBRARY_ATTACHMENTS, null);
    }
}

