/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.sdklib.repository.FullRevision;
import com.google.common.base.Strings;
import com.intellij.openapi.diagnostic.Logger;

final class GradleModelVersionCheck {
    private static final Logger LOG = Logger.getInstance(GradleModelVersionCheck.class);
    static final FullRevision MINIMUM_SUPPORTED_VERSION = FullRevision.parseRevision((String)"1.0.0");

    static boolean isSupportedVersion(AndroidProject androidProject) {
        return GradleModelVersionCheck.isSupportedVersion(androidProject, MINIMUM_SUPPORTED_VERSION);
    }

    static boolean isSupportedVersion(AndroidProject androidProject, FullRevision minimumSupportedVersion) {
        FullRevision version = GradleModelVersionCheck.getModelVersion(androidProject);
        if (version != null) {
            return version.compareTo(minimumSupportedVersion) >= 0;
        }
        return false;
    }

    static FullRevision getModelVersion(AndroidProject androidProject) {
        String modelVersion = androidProject.getModelVersion();
        if (Strings.isNullOrEmpty((String)modelVersion)) {
            return null;
        }
        int snapshotIndex = modelVersion.indexOf("-");
        if (snapshotIndex != -1) {
            modelVersion = modelVersion.substring(0, snapshotIndex);
        }
        try {
            return FullRevision.parseRevision((String)modelVersion);
        }
        catch (NumberFormatException e) {
            LOG.info(String.format("Unable to parse Gradle model version '%1$s'", modelVersion), (Throwable)e);
            return null;
        }
    }

    private GradleModelVersionCheck() {
    }
}

