/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.Variant;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.AndroidProjectKeys;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.ImportedModule;
import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.project.GradleModelVersionCheck;
import com.android.tools.idea.gradle.project.ProjectImportErrorHandler;
import com.android.tools.idea.gradle.project.SdkSync;
import com.android.tools.idea.gradle.service.notification.hyperlink.SyncProjectWithExtraCommandLineOptionsHyperlink;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Order(value=1000)
public class AndroidGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final String DEFAULT_TEST_ARTIFACT = "_android_test_";
    private final ProjectImportErrorHandler myErrorHandler;

    public AndroidGradleProjectResolver() {
        this(new ProjectImportErrorHandler());
    }

    @VisibleForTesting
    AndroidGradleProjectResolver(ProjectImportErrorHandler errorHandler) {
        this.myErrorHandler = errorHandler;
    }

    public ModuleData createModule(IdeaModule gradleModule, ProjectData projectData) {
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        if (androidProject != null && !GradleModelVersionCheck.isSupportedVersion(androidProject)) {
            ProjectImportErrorHandler.trackSyncError("syncFailedUnsupportedAndroidModelVersion", androidProject.getModelVersion());
            String msg = AndroidGradleProjectResolver.getUnsupportedModelVersionErrorMsg(GradleModelVersionCheck.getModelVersion(androidProject));
            throw new IllegalStateException(msg);
        }
        return this.nextResolver.createModule(gradleModule, projectData);
    }

    public void populateModuleContentRoots(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        File gradleSettingsFile;
        ImportedModule importedModule = new ImportedModule(gradleModule);
        ideModule.createChild(AndroidProjectKeys.IMPORTED_MODULE, (Object)importedModule);
        GradleProject gradleProject = gradleModule.getGradleProject();
        GradleScript buildScript = null;
        try {
            buildScript = gradleProject.getBuildScript();
        }
        catch (UnsupportedOperationException ignore) {
            // empty catch block
        }
        if (buildScript == null || !this.isAndroidGradleProject(gradleModule)) {
            this.nextResolver.populateModuleContentRoots(gradleModule, ideModule);
            return;
        }
        File moduleFilePath = new File(FileUtil.toSystemDependentName((String)((ModuleData)ideModule.getData()).getModuleFilePath()));
        File moduleRootDirPath = moduleFilePath.getParentFile();
        AndroidProject androidProject = (AndroidProject)this.resolverCtx.getExtraProject(gradleModule, AndroidProject.class);
        boolean androidProjectWithoutVariants = false;
        if (androidProject != null) {
            Variant selectedVariant = AndroidGradleProjectResolver.getVariantToSelect(androidProject);
            if (selectedVariant == null) {
                androidProjectWithoutVariants = true;
            } else {
                AndroidGradleModel androidModel = new AndroidGradleModel(GradleUtil.GRADLE_SYSTEM_ID, gradleModule.getName(), moduleRootDirPath, androidProject, selectedVariant.getName(), DEFAULT_TEST_ARTIFACT);
                ideModule.createChild(AndroidProjectKeys.ANDROID_MODEL, (Object)androidModel);
            }
        }
        if ((gradleSettingsFile = new File(moduleRootDirPath, "settings.gradle")).isFile() && androidProject == null) {
            this.createJavaProject(gradleModule, ideModule, false);
            return;
        }
        BuildScriptClasspathModel buildScriptModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(BuildScriptClasspathModel.class);
        String gradleVersion = buildScriptModel != null ? buildScriptModel.getGradleVersion() : null;
        File buildFilePath = buildScript.getSourceFile();
        GradleModel gradleModel = GradleModel.create(gradleModule.getName(), gradleProject, buildFilePath, gradleVersion);
        ideModule.createChild(AndroidProjectKeys.GRADLE_MODEL, (Object)gradleModel);
        if (androidProject == null || androidProjectWithoutVariants) {
            this.createJavaProject(gradleModule, ideModule, androidProjectWithoutVariants);
        }
    }

    private void createJavaProject(IdeaModule gradleModule, DataNode<ModuleData> ideModule, boolean androidProjectWithoutVariants) {
        ModuleExtendedModel model = (ModuleExtendedModel)this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        JavaProject javaProject = JavaProject.create(gradleModule, model, androidProjectWithoutVariants);
        ideModule.createChild(AndroidProjectKeys.JAVA_PROJECT, (Object)javaProject);
    }

    public void populateModuleCompileOutputSettings(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        if (!this.isAndroidGradleProject(gradleModule)) {
            this.nextResolver.populateModuleCompileOutputSettings(gradleModule, ideModule);
        }
    }

    public void populateModuleDependencies(IdeaModule gradleModule, DataNode<ModuleData> ideModule, DataNode<ProjectData> ideProject) {
        if (!this.isAndroidGradleProject(gradleModule)) {
            this.nextResolver.populateModuleDependencies(gradleModule, ideModule, ideProject);
        }
    }

    private boolean isAndroidGradleProject(IdeaModule gradleModule) {
        if (!this.resolverCtx.findModulesWithModel(AndroidProject.class).isEmpty()) {
            return true;
        }
        return "buildSrc".equals(gradleModule.getGradleProject().getName()) && AndroidStudioInitializer.isAndroidStudio();
    }

    public Set<Class> getExtraProjectModelClasses() {
        return Sets.newHashSet((Object[])new Class[]{AndroidProject.class});
    }

    public void preImportCheck() {
        Application application;
        Runnable task;
        if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_SYNC_TASK_IN_GUI_TEST_KEY, null);
            task.run();
        }
        if (AndroidStudioInitializer.isAndroidStudio()) {
            LocalProperties localProperties = this.getLocalProperties();
            SdkSync.syncIdeAndProjectAndroidSdks(localProperties);
        }
    }

    public List<KeyValue<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID)) {
            File androidHomePath;
            LocalProperties localProperties;
            ArrayList args = Lists.newArrayList();
            if (!AndroidStudioInitializer.isAndroidStudio() && (localProperties = this.getLocalProperties()).getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getAndroidSdkPath()) != null) {
                args.add(KeyValue.create((Object)"android.home", (Object)androidHomePath.getPath()));
            }
            return args;
        }
        return Collections.emptyList();
    }

    public List<String> getExtraCommandLineArgs() {
        String[] commandLineOptions;
        ArrayList args = Lists.newArrayList();
        Project project = this.findProject();
        if (project != null && (commandLineOptions = (String[])project.getUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY)) != null) {
            project.putUserData(SyncProjectWithExtraCommandLineOptionsHyperlink.EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, null);
            Collections.addAll(args, commandLineOptions);
        }
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.build.model.only.advanced", (boolean)true));
        args.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
        if (AndroidPlugin.isGuiTestingMode()) {
            ApplicationManager.getApplication().putUserData(AndroidPlugin.GRADLE_SYNC_COMMAND_LINE_OPTIONS_KEY, (Object)ArrayUtil.toStringArray((Collection)args));
        }
        GradleUtil.addLocalMavenRepoInitScriptCommandLineOption(args);
        return args;
    }

    private Project findProject() {
        String projectDir = this.resolverCtx.getProjectPath();
        if (StringUtil.isNotEmpty((String)projectDir)) {
            Project[] projects;
            File projectDirPath = new File(FileUtil.toSystemDependentName((String)projectDir));
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                File currentPath;
                String basePath = project.getBasePath();
                if (basePath == null || !FileUtil.filesEqual((File)projectDirPath, (File)(currentPath = new File(basePath)))) continue;
                return project;
            }
        }
        return null;
    }

    private LocalProperties getLocalProperties() {
        File projectDir = new File(FileUtil.toSystemDependentName((String)this.resolverCtx.getProjectPath()));
        try {
            return new LocalProperties(projectDir);
        }
        catch (IOException e) {
            String msg = String.format("Unable to read local.properties file in project '%1$s'", projectDir.getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    public ExternalSystemException getUserFriendlyError(Throwable error, String projectPath, String buildFilePath) {
        Throwable rootCause;
        String msg = error.getMessage();
        if (msg != null && !msg.contains("The project is using an unsupported version of the Android Gradle plug-in") && (rootCause = ExceptionUtil.getRootCause((Throwable)error)) instanceof ClassNotFoundException && ("org.gradle.api.artifacts.result.ResolvedComponentResult".equals(msg = rootCause.getMessage()) || "org.gradle.api.artifacts.result.ResolvedModuleVersionResult".equals(msg))) {
            ProjectImportErrorHandler.trackSyncError("gradleSyncFailure", "syncFailedUnsupportedGradleVersion");
            return new ExternalSystemException("The project is using an unsupported version of Gradle.");
        }
        ExternalSystemException userFriendlyError = this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
        if (userFriendlyError == null) {
            ProjectImportErrorHandler.trackSyncError(error);
            return this.nextResolver.getUserFriendlyError(error, projectPath, buildFilePath);
        }
        return userFriendlyError;
    }

    private static String getUnsupportedModelVersionErrorMsg(FullRevision modelVersion) {
        StringBuilder builder = new StringBuilder();
        builder.append("The project is using an unsupported version of the Android Gradle plug-in");
        String recommendedVersion = String.format("The recommended version is %1$s.", "1.5.0");
        if (modelVersion != null) {
            builder.append(String.format(" (%1$s).", modelVersion.toString())).append(" ").append(recommendedVersion);
            if (modelVersion.getMajor() == 0 && modelVersion.getMinor() <= 8) {
                builder.append("\n\nStarting with version 0.9.0 incompatible changes were introduced in the build language.\n").append("Please read the migration guide").append(" to learn how to update your project.");
            }
        } else {
            builder.append(". ").append(recommendedVersion);
        }
        return builder.toString();
    }

    private static Variant getVariantToSelect(AndroidProject androidProject) {
        Collection variants = androidProject.getVariants();
        if (variants.size() == 1) {
            Variant variant = (Variant)ContainerUtil.getFirstItem((Collection)variants);
            assert (variant != null);
            return variant;
        }
        for (Variant variant : variants) {
            if (!"debug".equals(variant.getName())) continue;
            return variant;
        }
        ArrayList sortedVariants = Lists.newArrayList((Iterable)variants);
        Collections.sort(sortedVariants, new Comparator<Variant>(){

            @Override
            public int compare(Variant o1, Variant o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedVariants.isEmpty() ? null : (Variant)sortedVariants.get(0);
    }

    public void enhanceRemoteProcessing(SimpleJavaParameters parameters) {
        ArrayList classPath = Lists.newArrayList();
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(((Object)((Object)this)).getClass()), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(FullRevision.class), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(AndroidGradleSettings.class), (Collection)classPath);
        ContainerUtil.addIfNotNull((Object)PathUtil.getJarPathForClass(AndroidProject.class), (Collection)classPath);
        parameters.getClassPath().addAll((List)classPath);
    }
}

