/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileKeyType;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

class GradleGroovyFile {
    private static final Logger LOG = Logger.getInstance(GradleGroovyFile.class);
    protected final Project myProject;
    protected final VirtualFile myFile;
    protected GroovyFile myGroovyFile = null;

    public GradleGroovyFile(VirtualFile file, Project project) {
        this.myProject = project;
        this.myFile = file;
        this.reload();
    }

    public Project getProject() {
        return this.myProject;
    }

    static void reformatClosure(GrStatementOwner closure) {
        new ReformatCodeProcessor(closure.getProject(), closure.getContainingFile(), closure.getParent().getTextRange(), false).runWithoutProgress();
        for (PsiElement psiElement : closure.getChildren()) {
            String text;
            if (!(psiElement instanceof LeafPsiElement) || !StringUtil.isEmptyOrSpaces((String)(text = psiElement.getText()))) continue;
            String newText = text;
            while (newText.contains("\n\n")) {
                newText = newText.replaceAll("\n\n", "\n");
            }
            if (newText.equals(text)) continue;
            ((LeafPsiElement)psiElement).replaceWithText(newText);
        }
    }

    static GrMethodCall createNewValue(GrStatementOwner root, BuildFileKey key, Object value, boolean reformatClosure) {
        GrStatement[] parentStatements;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)root.getProject());
        String path = key.getPath();
        String[] parts = path.split("/");
        GrStatementOwner parent = root;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            GrClosableBlock closure = GradleGroovyFile.getMethodClosureArgument(parent, part);
            if (closure == null) {
                parent.addStatementBefore(factory.createStatementFromText((CharSequence)(part + " {}")), null);
                closure = GradleGroovyFile.getMethodClosureArgument(parent, part);
                if (closure == null) {
                    return null;
                }
            }
            parent = closure;
        }
        String name = parts[parts.length - 1];
        String text = name + " " + key.getType().convertValueToExpression(value);
        GrStatement statementBefore = null;
        if (key.shouldInsertAtBeginning() && (parentStatements = parent.getStatements()).length > 0) {
            statementBefore = parentStatements[0];
        }
        parent.addStatementBefore(factory.createStatementFromText((CharSequence)text), statementBefore);
        if (reformatClosure) {
            GradleGroovyFile.reformatClosure(parent);
        }
        return GradleGroovyFile.getMethodCall(parent, name);
    }

    public void reload() {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                if (!GradleGroovyFile.this.myFile.exists()) {
                    LOG.warn("File " + GradleGroovyFile.this.myFile.getPath() + " no longer exists");
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)GradleGroovyFile.this.myProject).findFile(GradleGroovyFile.this.myFile);
                if (psiFile == null) {
                    LOG.warn("Could not find PsiFile for " + GradleGroovyFile.this.myFile.getPath());
                    return;
                }
                if (!(psiFile instanceof GroovyFile)) {
                    LOG.warn("PsiFile " + psiFile.getName() + " is not a Groovy file");
                    return;
                }
                GradleGroovyFile.this.myGroovyFile = (GroovyFile)psiFile;
                GradleGroovyFile.this.onPsiFileAvailable();
            }
        });
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public PsiFile getPsiFile() {
        return this.myGroovyFile;
    }

    protected void checkInitialized() {
        if (this.myGroovyFile == null) {
            throw new IllegalStateException("PsiFile not parsed for file " + this.myFile.getPath() + ". Wait until onPsiFileAvailable() is called.");
        }
    }

    protected void commitDocumentChanges() {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = documentManager.getDocument((PsiFile)this.myGroovyFile);
        if (document != null) {
            documentManager.commitDocument(document);
        }
    }

    protected static GrMethodCall getMethodCallByPath(GrStatementOwner root, String path) {
        if (path.isEmpty() || path.endsWith("/")) {
            return null;
        }
        int slash = path.indexOf(47);
        String pathElement = slash == -1 ? path : path.substring(0, slash);
        for (GrMethodCall gmc : GradleGroovyFile.getMethodCalls(root, pathElement)) {
            if (slash == -1) {
                return gmc;
            }
            if (gmc == null) {
                return null;
            }
            GrClosableBlock[] blocks = gmc.getClosureArguments();
            if (blocks.length != 1) {
                return null;
            }
            GrMethodCall subresult = GradleGroovyFile.getMethodCallByPath((GrStatementOwner)blocks[0], path.substring(slash + 1));
            if (subresult == null) continue;
            return subresult;
        }
        return null;
    }

    protected static GroovyPsiElement[] getArguments(GrCall gmc) {
        GrArgumentList argList = gmc.getArgumentList();
        if (argList == null) {
            return GroovyPsiElement.EMPTY_ARRAY;
        }
        return argList.getAllArguments();
    }

    protected static GroovyPsiElement getFirstArgument(GrCall gmc) {
        GroovyPsiElement[] arguments = GradleGroovyFile.getArguments(gmc);
        return arguments.length > 0 ? arguments[0] : null;
    }

    protected static String getSingleStringArgumentValue(GrCall methodCall) {
        GroovyPsiElement argument = GradleGroovyFile.getFirstArgument(methodCall);
        if (argument instanceof GrLiteral) {
            Object value = ((GrLiteral)argument).getValue();
            return value instanceof String ? (String)value : null;
        }
        return null;
    }

    protected static GrMethodCall getMethodCall(GrStatementOwner parent, String methodName) {
        return (GrMethodCall)Iterables.getFirst(GradleGroovyFile.getMethodCalls(parent, methodName), null);
    }

    protected static Iterable<GrMethodCall> getMethodCalls(GrStatementOwner parent) {
        return Iterables.filter(Arrays.asList(parent.getStatements()), GrMethodCall.class);
    }

    protected static Iterable<GrMethodCall> getMethodCalls(GrStatementOwner parent, final String methodName) {
        return Iterables.filter(GradleGroovyFile.getMethodCalls(parent), (Predicate)new Predicate<GrMethodCall>(){

            public boolean apply(GrMethodCall input) {
                return input != null && methodName.equals(GradleGroovyFile.getMethodCallName(input));
            }
        });
    }

    protected static String getMethodCallName(GrMethodCall gmc) {
        GrExpression expression = gmc.getInvokedExpression();
        return expression.getText() != null ? expression.getText() : "";
    }

    protected static <E> Iterable<E> getTypedArguments(GrArgumentList args, Class<E> clazz) {
        return Iterables.filter(Arrays.asList(args.getAllArguments()), clazz);
    }

    protected static Iterable<GrLiteral> getLiteralArguments(GrMethodCall gmc) {
        GrArgumentList argumentList = gmc.getArgumentList();
        return GradleGroovyFile.getTypedArguments(argumentList, GrLiteral.class);
    }

    protected static Iterable<Object> getLiteralArgumentValues(GrMethodCall gmc) {
        return Iterables.filter((Iterable)Iterables.transform(GradleGroovyFile.getLiteralArguments(gmc), (Function)new Function<GrLiteral, Object>(){

            public Object apply(GrLiteral input) {
                return input != null ? input.getValue() : null;
            }
        }), (Predicate)Predicates.notNull());
    }

    protected static Map<String, Object> getNamedArgumentValues(GrMethodCall gmc) {
        GrArgumentList argumentList = gmc.getArgumentList();
        HashMap values = Maps.newHashMap();
        for (GrNamedArgument grNamedArgument : GradleGroovyFile.getTypedArguments(argumentList, GrNamedArgument.class)) {
            values.put(grNamedArgument.getLabelName(), GradleGroovyFile.parseValueExpression(grNamedArgument.getExpression()));
        }
        return values;
    }

    protected static Object parseValueExpression(GrExpression gre) {
        if (gre instanceof GrLiteral) {
            return ((GrLiteral)gre).getValue();
        }
        if (gre instanceof GrListOrMap) {
            GrListOrMap grLom = (GrListOrMap)gre;
            if (grLom.isMap()) {
                return null;
            }
            ArrayList values = Lists.newArrayList();
            for (GrExpression subexpression : grLom.getInitializers()) {
                Object subValue = GradleGroovyFile.parseValueExpression(subexpression);
                if (subValue == null) continue;
                values.add(subValue);
            }
            return values;
        }
        return null;
    }

    protected static String convertMapToGroovySource(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(GradleGroovyFile.convertValueToGroovySource(entry.getValue()));
        }
        return sb.toString();
    }

    protected static String convertValueToGroovySource(Object value) {
        if (value instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (Object v : (List)value) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(GradleGroovyFile.convertValueToGroovySource(v));
            }
            sb.append(']');
            return sb.toString();
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        return "'" + BuildFileKey.escapeLiteralString(value.toString()) + "'";
    }

    protected static Object getFirstLiteralArgumentValue(GrMethodCall gmc) {
        GrLiteral lit = GradleGroovyFile.getFirstLiteralArgument(gmc);
        return lit != null ? lit.getValue() : null;
    }

    protected static GrLiteral getFirstLiteralArgument(GrMethodCall gmc) {
        return (GrLiteral)Iterables.getFirst(GradleGroovyFile.getLiteralArguments(gmc), null);
    }

    protected static GrClosableBlock getMethodClosureArgument(GrStatementOwner parent, String methodName) {
        GrMethodCall methodCall = GradleGroovyFile.getMethodCall(parent, methodName);
        if (methodCall == null) {
            return null;
        }
        return GradleGroovyFile.getMethodClosureArgument(methodCall);
    }

    public static GrClosableBlock getMethodClosureArgument(GrMethodCall methodCall) {
        return (GrClosableBlock)Iterables.getFirst(Arrays.asList(methodCall.getClosureArguments()), null);
    }

    static Object getValueStatic(GrStatementOwner root, BuildFileKey key) {
        GrClosableBlock arg;
        GrMethodCall method = GradleGroovyFile.getMethodCallByPath(root, key.getPath());
        if (method == null) {
            return null;
        }
        Object object = arg = key.getType() == BuildFileKeyType.CLOSURE ? GradleGroovyFile.getMethodClosureArgument(method) : GradleGroovyFile.getFirstArgument((GrCall)method);
        if (arg == null) {
            return null;
        }
        return key.getValue((GroovyPsiElement)arg);
    }

    static void setValueStatic(GrStatementOwner root, BuildFileKey key, Object value, boolean reformatClosure, ValueFactory.KeyFilter filter) {
        if (value == GradleBuildFile.UNRECOGNIZED_VALUE) {
            return;
        }
        GrMethodCall method = GradleGroovyFile.getMethodCallByPath(root, key.getPath());
        if (method == null) {
            method = GradleGroovyFile.createNewValue(root, key, value, reformatClosure);
            if (key.getType() != BuildFileKeyType.CLOSURE) {
                return;
            }
        }
        if (method != null) {
            GrClosableBlock arg;
            Object object = arg = key.getType() == BuildFileKeyType.CLOSURE ? GradleGroovyFile.getMethodClosureArgument(method) : GradleGroovyFile.getFirstArgument((GrCall)method);
            if (arg == null) {
                return;
            }
            key.setValue((GroovyPsiElement)arg, value, filter);
        }
    }

    static void removeValueStatic(GrStatementOwner root, BuildFileKey key) {
        GrMethodCall method = GradleGroovyFile.getMethodCallByPath(root, key.getPath());
        if (method != null) {
            method.delete();
        }
    }

    protected void onPsiFileAvailable() {
    }

    public String toString() {
        if (this.myGroovyFile == null) {
            return "<uninitialized>";
        }
        ToStringPsiVisitor visitor = new ToStringPsiVisitor();
        this.myGroovyFile.accept((PsiElementVisitor)visitor);
        return this.myFile.getPath() + ":\n" + visitor.toString();
    }

    private static class ToStringPsiVisitor
    extends PsiRecursiveElementVisitor {
        private StringBuilder myString = new StringBuilder();

        private ToStringPsiVisitor() {
        }

        public void visitElement(PsiElement element) {
            PsiElement e = element;
            while (e.getParent() != null) {
                this.myString.append("  ");
                e = e.getParent();
            }
            this.myString.append(element.getClass().getName());
            this.myString.append(": ");
            this.myString.append(element.toString());
            if (element instanceof LeafPsiElement) {
                this.myString.append(" ");
                this.myString.append(element.getText());
            }
            this.myString.append("\n");
            super.visitElement(element);
        }

        public String toString() {
            return this.myString.toString();
        }
    }
}

