/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public enum BuildFileKeyType {
    STRING((Class)String.class, "''"){

        @Override
        public void setValue(GroovyPsiElement arg, Object value) {
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createLiteralFromValue((Object)value.toString()));
        }

        @Override
        public String convertValueToExpression(Object value) {
            return "'" + BuildFileKey.escapeLiteralString(value.toString()) + "'";
        }
    }
    ,
    INTEGER(Integer.class, "0"),
    INTEGER_OR_STRING((Class)String.class, "0"){

        @Override
        public void setValue(GroovyPsiElement arg, Object value) {
            String valueString = value.toString();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)arg.getProject());
            if (BuildFileKeyType.isInteger(valueString)) {
                arg.replace((PsiElement)factory.createExpressionFromText((CharSequence)valueString));
            } else {
                arg.replace((PsiElement)factory.createLiteralFromValue(value));
            }
        }

        @Override
        public String convertValueToExpression(Object value) {
            String valueString = value.toString();
            if (BuildFileKeyType.isInteger(valueString)) {
                return valueString;
            }
            return "'" + BuildFileKey.escapeLiteralString(value.toString()) + "'";
        }

        @Override
        public Object getValue(GroovyPsiElement arg) {
            if (!(arg instanceof GrLiteral)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object value = ((GrLiteral)arg).getValue();
            return value != null ? value.toString() : null;
        }
    }
    ,
    BOOLEAN(Boolean.class, "false"),
    CLOSURE((Class)List.class, "{}"){

        @Override
        public String convertValueToExpression(Object value) {
            return "{\n}";
        }
    }
    ,
    FILE((Class)File.class, "file('')"){

        @Override
        public Object getValue(GroovyPsiElement arg) {
            if (!(arg instanceof GrMethodCall)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            GrMethodCall call = (GrMethodCall)arg;
            if (!"file".equals(GradleGroovyFile.getMethodCallName(call))) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object path = GradleGroovyFile.getFirstLiteralArgumentValue(call);
            if (path == null) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            return new File(path.toString());
        }

        @Override
        public void setValue(GroovyPsiElement arg, Object value) {
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createStatementFromText((CharSequence)("file('" + BuildFileKeyType.getFilePath(value, true) + "')")));
        }

        @Override
        public String convertValueToExpression(Object value) {
            return "file('" + BuildFileKeyType.getFilePath(value, true) + "')";
        }
    }
    ,
    FILE_AS_STRING((Class)File.class, "''"){

        @Override
        public Object getValue(GroovyPsiElement arg) {
            if (!(arg instanceof GrLiteral)) {
                return GradleBuildFile.UNRECOGNIZED_VALUE;
            }
            Object value = ((GrLiteral)arg).getValue();
            return value != null ? new File(value.toString()) : null;
        }

        @Override
        public void setValue(GroovyPsiElement arg, Object value) {
            arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createLiteralFromValue((Object)BuildFileKeyType.getFilePath(value, false)));
        }

        @Override
        public String convertValueToExpression(Object value) {
            return "'" + BuildFileKeyType.getFilePath(value, true) + "'";
        }
    }
    ,
    REFERENCE((Class)String.class, "reference"){

        @Override
        public Object getValue(GroovyPsiElement arg) {
            return arg.getText();
        }
    };

    private final Class<?> myNativeType;
    private final String myDefaultValue;

    private BuildFileKeyType(Class<?> nativeType, String defaultValue) {
        this.myNativeType = nativeType;
        this.myDefaultValue = defaultValue;
    }

    public Class<?> getNativeType() {
        return this.myNativeType;
    }

    public String convertValueToExpression(Object value) {
        return value.toString();
    }

    private static String getFilePath(Object value, boolean escape) {
        String path = FileUtil.toSystemIndependentName((String)((File)value).getPath());
        return escape ? BuildFileKey.escapeLiteralString(path) : path;
    }

    public Object getValue(GroovyPsiElement arg) {
        if (!(arg instanceof GrLiteral)) {
            return GradleBuildFile.UNRECOGNIZED_VALUE;
        }
        return ((GrLiteral)arg).getValue();
    }

    public void setValue(GroovyPsiElement arg, Object value) {
        arg.replace((PsiElement)GroovyPsiElementFactory.getInstance((Project)arg.getProject()).createExpressionFromText((CharSequence)value.toString()));
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class Constants {
        private static final String FILE_METHOD_CALL = "file";

        private Constants() {
        }
    }
}

