/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.compatibility.VersionCompatibilityService;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.wizard.SdkQuickfixWizard;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ProjectSyncMessages {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    private final Project myProject;
    private final ExternalSystemNotificationManager myNotificationManager;

    public static ProjectSyncMessages getInstance(Project project) {
        return (ProjectSyncMessages)ServiceManager.getService((Project)project, ProjectSyncMessages.class);
    }

    public int getErrorCount() {
        return this.myNotificationManager.getMessageCount(null, NOTIFICATION_SOURCE, NotificationCategory.ERROR, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public ProjectSyncMessages(Project project, ExternalSystemNotificationManager manager) {
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public int getMessageCount(String groupName) {
        return this.myNotificationManager.getMessageCount(groupName, NOTIFICATION_SOURCE, null, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public boolean isEmpty() {
        return this.myNotificationManager.getMessageCount(NOTIFICATION_SOURCE, null, GradleUtil.GRADLE_SYSTEM_ID) == 0;
    }

    public void reportComponentIncompatibilities() {
        VersionCompatibilityService compatibilityService = VersionCompatibilityService.getInstance();
        List<VersionCompatibilityService.VersionIncompatibilityMessage> messages = compatibilityService.checkComponentCompatibility(this.myProject);
        for (VersionCompatibilityService.VersionIncompatibilityMessage message : messages) {
            this.add(message.getMessage(), message.getQuickFixes());
        }
        if (!messages.isEmpty()) {
            Projects.setHasSyncErrors(this.myProject, true);
        }
    }

    public void reportSyncIssues(Collection<SyncIssue> syncIssues, Module module) {
        if (syncIssues.isEmpty()) {
            return;
        }
        boolean hasSyncErrors = false;
        VirtualFile buildFile = ProjectSyncMessages.getBuildFile(module);
        block3: for (SyncIssue syncIssue : syncIssues) {
            if (syncIssue.getSeverity() == 2) {
                hasSyncErrors = true;
            }
            switch (syncIssue.getType()) {
                case 2: {
                    this.reportUnresolvedDependency(syncIssue.getData(), module, buildFile);
                    continue block3;
                }
            }
            String group = "Gradle Sync Issue";
            String text = syncIssue.getMessage();
            Message.Type severity = syncIssue.getType() == 2 ? Message.Type.ERROR : Message.Type.WARNING;
            Message msg = buildFile != null ? new Message(module.getProject(), group, severity, buildFile, -1, -1, text) : new Message(group, severity, NonNavigatable.INSTANCE, text);
            this.add(msg, new NotificationHyperlink[0]);
        }
        if (hasSyncErrors) {
            Projects.setHasSyncErrors(this.myProject, true);
        }
    }

    public void reportUnresolvedDependencies(Collection<String> unresolvedDependencies, Module module) {
        if (unresolvedDependencies.isEmpty()) {
            return;
        }
        VirtualFile buildFile = ProjectSyncMessages.getBuildFile(module);
        for (String dep : unresolvedDependencies) {
            this.reportUnresolvedDependency(dep, module, buildFile);
        }
        Projects.setHasSyncErrors(this.myProject, true);
    }

    private static VirtualFile getBuildFile(Module module) {
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleModel() != null) {
            GradleModel gradleModel = gradleFacet.getGradleModel();
            return gradleModel.getBuildFile();
        }
        return null;
    }

    private void reportUnresolvedDependency(String dependency, Module module, VirtualFile buildFile) {
        GradleCoordinate coordinate;
        Message msg;
        String group;
        ArrayList hyperlinks = Lists.newArrayList();
        if (dependency.startsWith("com.android.support")) {
            group = "Unresolved Android dependencies";
            hyperlinks.add(new InstallRepositoryHyperlink(SdkMavenRepository.ANDROID));
        } else if (dependency.startsWith("com.google.android")) {
            group = "Unresolved Android dependencies";
            hyperlinks.add(new InstallRepositoryHyperlink(SdkMavenRepository.GOOGLE));
        } else {
            group = "Unresolved dependencies";
            if (Projects.isOfflineBuildModeEnabled(this.myProject)) {
                NotificationHyperlink disableOfflineModeHyperlink = new NotificationHyperlink("disable.gradle.offline.mode", "Disable offline mode and Sync"){

                    @Override
                    protected void execute(Project project) {
                        GradleSettings.getInstance((Project)ProjectSyncMessages.this.myProject).setOfflineWork(false);
                        GradleProjectImporter.getInstance().requestProjectSync(project, null);
                    }
                };
                hyperlinks.add(disableOfflineModeHyperlink);
            }
        }
        String text = "Failed to resolve: " + dependency;
        if (buildFile != null) {
            TextRange textRange;
            int lineNumber = -1;
            int column = -1;
            Document document = FileDocumentManager.getInstance().getDocument(buildFile);
            if (document != null && (textRange = GradleUtil.findDependency(dependency, document.getText())) != null && (lineNumber = document.getLineNumber(textRange.getStartOffset())) > -1) {
                int lineStartOffset = document.getLineStartOffset(lineNumber);
                column = textRange.getStartOffset() - lineStartOffset;
            }
            msg = new Message(module.getProject(), group, Message.Type.ERROR, buildFile, lineNumber, column, text);
            String hyperlinkText = lineNumber > -1 ? "Show in File" : "Open File";
            hyperlinks.add(new OpenFileHyperlink(buildFile.getPath(), hyperlinkText, lineNumber, column));
        } else {
            msg = new Message(group, Message.Type.ERROR, NonNavigatable.INSTANCE, text);
        }
        if (AndroidStudioInitializer.isAndroidStudio() && (coordinate = GradleCoordinate.parseCoordinateString((String)dependency)) != null) {
            hyperlinks.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        this.add(msg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    public void reportDependencySetupErrors() {
        DependencySetupErrors setupErrors = Projects.getDependencySetupErrors(this.myProject);
        if (setupErrors != null) {
            this.reportModulesNotFoundErrors(setupErrors);
            Projects.setDependencySetupErrors(this.myProject, null);
        }
    }

    private void reportModulesNotFoundErrors(DependencySetupErrors setupErrors) {
        String msg;
        this.reportModulesNotFoundIssues("Missing dependencies between modules", setupErrors.getMissingModules());
        for (String dependent : setupErrors.getMissingNames()) {
            msg = String.format("Module '%1$s' depends on modules that do not have a name.", dependent);
            this.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg), new NotificationHyperlink[0]);
        }
        for (String dependent : setupErrors.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg), new NotificationHyperlink[0]);
        }
        for (DependencySetupErrors.InvalidModuleDependency dependency : setupErrors.getInvalidModuleDependencies()) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.detail);
            VirtualFile buildFile = ProjectSyncMessages.getBuildFile(dependency.dependency);
            assert (buildFile != null);
            this.add(new Message("Failed to set up dependencies", Message.Type.WARNING, (Navigatable)new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0), msg), new NotificationHyperlink[0]);
        }
        this.reportModulesNotFoundIssues("Failed to set up dependencies", setupErrors.getMissingModulesWithBackupLibraries());
    }

    private void reportModulesNotFoundIssues(String groupName, List<DependencySetupErrors.MissingModule> missingModules) {
        if (!missingModules.isEmpty()) {
            boolean hasSelection;
            Message.Type severity = Message.Type.ERROR;
            for (DependencySetupErrors.MissingModule missingModule : missingModules) {
                ArrayList messageLines = Lists.newArrayList();
                StringBuilder text = new StringBuilder();
                text.append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                ProjectSyncMessages.addDependentsToText(text, missingModule.dependentNames);
                text.append(".)");
                messageLines.add(text.toString());
                String backupLibraryName = missingModule.backupLibraryName;
                if (StringUtil.isNotEmpty((String)backupLibraryName)) {
                    severity = Message.Type.WARNING;
                    String msg = String.format("Linking to library '%1$s' instead.", backupLibraryName);
                    messageLines.add(msg);
                }
                this.add(new Message(groupName, severity, ArrayUtil.toStringArray((Collection)messageLines)), new NotificationHyperlink[0]);
            }
            ProjectSubset projectSubset = ProjectSubset.getInstance(this.myProject);
            String[] selection = projectSubset.getSelection();
            boolean bl = hasSelection = selection != null && selection.length > 0;
            if (severity == Message.Type.ERROR && hasSelection && projectSubset.hasCachedModules()) {
                String msg = "The missing modules may have been excluded from the project subset.";
                this.add(new Message(groupName, Message.Type.INFO, msg), new IncludeMissingModulesHyperlink(missingModules));
            }
        }
    }

    private static void addDependentsToText(StringBuilder text, List<String> dependents) {
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i = 0;
        for (String dependent : dependents) {
            if (i++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    public void add(Message message, NotificationHyperlink ... hyperlinks) {
        Navigatable navigatable = message.getNavigatable();
        String title = message.getGroupName();
        String errorMsg = StringUtil.join((String[])message.getText(), (String)"\n");
        VirtualFile file = message.getFile();
        String filePath = file != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file).getPath() : null;
        NotificationCategory category = NotificationCategory.convert((int)message.getType().getValue());
        NotificationData notification = new NotificationData(title, errorMsg, category, NOTIFICATION_SOURCE, filePath, message.getLine(), message.getColumn(), false);
        notification.setNavigatable(navigatable);
        if (hyperlinks.length > 0) {
            AbstractSyncErrorHandler.updateNotification(notification, this.myProject, title, errorMsg, hyperlinks);
        }
        this.myNotificationManager.showNotification(GradleUtil.GRADLE_SYSTEM_ID, notification);
    }

    public void removeMessages(String ... groupNames) {
        for (String groupName : groupNames) {
            this.myNotificationManager.clearNotifications(groupName, NOTIFICATION_SOURCE, GradleUtil.GRADLE_SYSTEM_ID);
        }
    }

    private static class IncludeMissingModulesHyperlink
    extends NotificationHyperlink {
        private final Set<String> myModuleGradlePaths;

        IncludeMissingModulesHyperlink(List<DependencySetupErrors.MissingModule> missingModules) {
            super("include.missing.modules", "Find and include missing modules");
            this.myModuleGradlePaths = Sets.newHashSetWithExpectedSize((int)missingModules.size());
            for (DependencySetupErrors.MissingModule module : missingModules) {
                this.myModuleGradlePaths.add(module.dependencyPath);
            }
        }

        @Override
        protected void execute(Project project) {
            ProjectSubset.getInstance(project).findAndIncludeModules(this.myModuleGradlePaths);
        }
    }

    private static class InstallRepositoryHyperlink
    extends NotificationHyperlink {
        private final SdkMavenRepository myRepository;

        InstallRepositoryHyperlink(SdkMavenRepository repository) {
            super("install.m2.repo", "Install Repository and sync project");
            this.myRepository = repository;
        }

        @Override
        protected void execute(Project project) {
            ArrayList requested = Lists.newArrayList();
            requested.add(this.myRepository.getPackageDescription());
            SdkQuickfixWizard wizard = new SdkQuickfixWizard(project, null, requested);
            wizard.init();
            wizard.setTitle("Install Missing Components");
            if (wizard.showAndGet()) {
                GradleProjectImporter.getInstance().requestProjectSync(project, null);
            }
        }
    }

    private static class ShowDependencyInProjectStructureHyperlink
    extends NotificationHyperlink {
        private final Module myModule;
        private final GradleCoordinate myDependency;

        ShowDependencyInProjectStructureHyperlink(Module module, GradleCoordinate dependency) {
            super("open.dependency.in.project.structure", "Show in Project Structure dialog");
            this.myModule = module;
            this.myDependency = dependency;
        }

        @Override
        protected void execute(Project project) {
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openAndSelectDependency(this.myModule, this.myDependency);
            }
        }
    }
}

