/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.utils.SdkUtils;
import com.google.common.io.Closeables;
import com.intellij.execution.ui.ConsoleViewContentType;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.tooling.BuildLauncher;

class GradleOutputForwarder {
    private static final int SIZE = 2048;
    private final ByteArrayOutputStream myStdErr;
    private final ByteArrayOutputStream myOutput;
    private final GradleConsoleView myConsoleView;
    private ConsoleViewContentType myPreviousContentType;

    GradleOutputForwarder(GradleConsoleView consoleView) {
        this.myConsoleView = consoleView;
        this.myStdErr = new ByteArrayOutputStream(2048);
        this.myOutput = new ByteArrayOutputStream(4096);
    }

    void attachTo(BuildLauncher launcher, Listener listener) {
        ConsoleAwareOutputStream stdout = new ConsoleAwareOutputStream(this, ConsoleViewContentType.NORMAL_OUTPUT, listener);
        ConsoleAwareOutputStream stderr = new ConsoleAwareOutputStream(this, ConsoleViewContentType.ERROR_OUTPUT, listener);
        launcher.setStandardOutput((OutputStream)stdout);
        launcher.setStandardError((OutputStream)stderr);
    }

    void close() {
        try {
            Closeables.close((Closeable)this.myOutput, (boolean)true);
            Closeables.close((Closeable)this.myStdErr, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getStdErr() {
        return this.myStdErr.toString();
    }

    void write(ConsoleViewContentType contentType, byte[] b, int off, int len) {
        String text;
        boolean addNewLine = false;
        if (contentType != this.myPreviousContentType) {
            addNewLine = this.myPreviousContentType != null;
            this.myPreviousContentType = contentType;
        }
        String lineSeparator = SdkUtils.getLineSeparator();
        boolean newLineAdded = false;
        if (addNewLine) {
            byte[] bytes = lineSeparator.getBytes();
            this.myOutput.write(bytes, 0, bytes.length);
            this.myConsoleView.print(lineSeparator, contentType);
            newLineAdded = true;
        }
        if (lineSeparator.equals(text = new String(b, off, len)) && newLineAdded) {
            return;
        }
        this.myOutput.write(b, off, len);
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
            this.myStdErr.write(b, off, len);
        }
        this.myConsoleView.print(text, contentType);
    }

    public String toString() {
        return this.myOutput.toString();
    }

    private static class ConsoleAwareOutputStream
    extends OutputStream {
        private final GradleOutputForwarder myOutput;
        private final ConsoleViewContentType myContentType;
        private final Listener myListener;

        ConsoleAwareOutputStream(GradleOutputForwarder output, ConsoleViewContentType contentType, Listener listener) {
            this.myOutput = output;
            this.myContentType = contentType;
            this.myListener = listener;
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (this.myListener != null) {
                this.myListener.onOutput(this.myContentType, b, off, len);
            }
            this.myOutput.write(this.myContentType, b, off, len);
        }
    }

    static interface Listener {
        public void onOutput(ConsoleViewContentType var1, byte[] var2, int var3, int var4);
    }
}

