/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.android.tools.idea.gradle.editor.ui.DummyGradleEditorEntityUi;
import com.android.tools.idea.gradle.editor.ui.ExternalDependencyEntityUi;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUi;
import com.android.tools.idea.gradle.editor.ui.SimpleGradleEntityUi;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GradleEditorEntityUiRegistry {
    private final NotNullLazyValue<Set<GradleEditorEntityUi<?>>> myUis = new NotNullLazyValue<Set<GradleEditorEntityUi<?>>>(){

        protected Set<GradleEditorEntityUi<?>> compute() {
            HashSet result = Sets.newHashSet();
            result.add(new SimpleGradleEntityUi());
            result.add(new ExternalDependencyEntityUi());
            Collections.addAll(result, GradleEditorEntityUi.EP_NAME.getExtensions());
            return result;
        }
    };
    private final DummyGradleEditorEntityUi myDummyUi = new DummyGradleEditorEntityUi();

    public List<GradleEditorEntityUi<?>> getEntityUis(final GradleEditorEntity entity) {
        List candidates = ContainerUtil.filter((Collection)((Collection)this.myUis.getValue()), (Condition)new Condition<GradleEditorEntityUi<?>>(){

            public boolean value(GradleEditorEntityUi<?> renderer) {
                return renderer.getTargetEntityClass().isInstance(entity);
            }
        });
        if (candidates.isEmpty()) {
            return Collections.singletonList(this.myDummyUi);
        }
        ExternalSystemApiUtil.orderAwareSort((List)candidates);
        return candidates;
    }

    public boolean hasEntityUi(final GradleEditorEntity entity) {
        return null != ContainerUtil.find((Iterable)((Iterable)this.myUis.getValue()), (Condition)new Condition<GradleEditorEntityUi<?>>(){

            public boolean value(GradleEditorEntityUi<?> ui) {
                return ui.getTargetEntityClass().isInstance(entity);
            }
        });
    }
}

