/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Collections;
import java.util.List;

public class GradleEditorEntityGroup
implements Disposable {
    private final String myName;
    private final List<GradleEditorEntity> myEntities;
    private final List<GradleEditorEntity> myEntitiesView;

    public GradleEditorEntityGroup(String name) {
        this(name, Collections.emptyList());
    }

    public GradleEditorEntityGroup(String name, Iterable<GradleEditorEntity> entities) {
        this.myName = name;
        this.myEntities = Lists.newArrayList(entities);
        this.myEntitiesView = Collections.unmodifiableList(this.myEntities);
    }

    public String getName() {
        return this.myName;
    }

    public List<GradleEditorEntity> getEntities() {
        return this.myEntitiesView;
    }

    public void addEntity(GradleEditorEntity entity) {
        this.myEntities.add(entity);
    }

    public void dispose() {
        for (GradleEditorEntity entity : this.myEntities) {
            Disposer.dispose((Disposable)entity);
        }
    }

    public String toString() {
        return String.format("%s [%d entities]", this.myName, this.myEntities.size());
    }
}

