/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.AbstractGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDeclarationValueLocationAware;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.Set;

public class ExternalDependencyGradleEditorEntity
extends AbstractGradleEditorEntity
implements GradleEntityDeclarationValueLocationAware,
GradleEntityDefinitionValueLocationAware {
    private String myScope;
    private final List<GradleEditorSourceBinding> myScopeBindings = Lists.newArrayList();
    private String myGroupId;
    private final List<GradleEditorSourceBinding> myGroupIdSourceBindings = Lists.newArrayList();
    private String myArtifactId;
    private final List<GradleEditorSourceBinding> myArtifactIdSourceBindings = Lists.newArrayList();
    private String myVersion;
    private final List<GradleEditorSourceBinding> myVersionSourceBindings = Lists.newArrayList();
    private final GradleEditorSourceBinding myVersionDeclarationLocation;
    private final GradleEditorEntityValueManager myVersionValueManager;

    public ExternalDependencyGradleEditorEntity(String scope, List<GradleEditorSourceBinding> scopeSourceBindings, String groupId, List<GradleEditorSourceBinding> groupIdSourceBindings, String artifactId, List<GradleEditorSourceBinding> artifactIdSourceBindings, String version, List<GradleEditorSourceBinding> versionSourceBindings, GradleEditorSourceBinding entityLocation, GradleEditorSourceBinding versionDeclarationLocation, GradleEditorEntityValueManager versionValueManager, Set<GradleEditorEntityMetaData> metaData) {
        super(entityLocation, metaData, null);
        this.myScope = scope;
        this.myScopeBindings.addAll(scopeSourceBindings);
        this.myGroupId = groupId;
        this.myGroupIdSourceBindings.addAll(groupIdSourceBindings);
        this.myArtifactId = artifactId;
        this.myArtifactIdSourceBindings.addAll(artifactIdSourceBindings);
        this.myVersion = version;
        this.myVersionSourceBindings.addAll(versionSourceBindings);
        this.myVersionDeclarationLocation = versionDeclarationLocation;
        this.myVersionValueManager = versionValueManager;
    }

    @Override
    public String getName() {
        return String.format("%s %s:%s:%s", this.myScope, this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public String getScope() {
        return this.myScope;
    }

    public List<GradleEditorSourceBinding> getScopeBindings() {
        return this.myScopeBindings;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public List<GradleEditorSourceBinding> getGroupIdSourceBindings() {
        return this.myGroupIdSourceBindings;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public List<GradleEditorSourceBinding> getArtifactIdSourceBindings() {
        return this.myArtifactIdSourceBindings;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public List<GradleEditorSourceBinding> getVersionSourceBindings() {
        return this.myVersionSourceBindings;
    }

    @Override
    public GradleEditorSourceBinding getDeclarationValueLocation() {
        return this.myVersionDeclarationLocation;
    }

    @Override
    public GradleEditorSourceBinding getDefinitionValueLocation() {
        return this.myVersionSourceBindings.size() == 1 ? this.myVersionSourceBindings.get(0) : null;
    }

    public GradleEditorEntityValueManager getVersionValueManager() {
        return this.myVersionValueManager;
    }

    public String changeVersion(String newVersion) {
        if (newVersion.equals(this.getVersion())) {
            return null;
        }
        List<GradleEditorSourceBinding> sourceBindings = this.getVersionSourceBindings();
        if (sourceBindings.size() != 1) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: expected the entity to hold only one version source binding but it has %d (%s)", newVersion, this, sourceBindings.size(), sourceBindings);
        }
        GradleEditorSourceBinding binding = sourceBindings.get(0);
        RangeMarker rangeMarker = binding.getRangeMarker();
        if (!rangeMarker.isValid()) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: source file binding is incorrect", newVersion, this);
        }
        this.myVersion = newVersion;
        rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)newVersion);
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myVersionDeclarationLocation);
        for (GradleEditorSourceBinding binding : this.myScopeBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myGroupIdSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myArtifactIdSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myVersionSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.getMetaData().isEmpty()) {
            buffer.append('[').append(Joiner.on((char)'|').join(this.getMetaData())).append("] ");
        }
        buffer.append(this.myScope.isEmpty() ? String.format("<defined %d times>", this.myScopeBindings.size()) : this.myScope);
        buffer.append(" ").append(this.myGroupId.isEmpty() ? String.format("<defined %d times>", this.myGroupIdSourceBindings.size()) : this.myGroupId);
        buffer.append(":").append(this.myArtifactId.isEmpty() ? String.format("<defined %d times>", this.myArtifactIdSourceBindings.size()) : this.myArtifactId);
        buffer.append(":").append(this.myVersion.isEmpty() ? String.format("<defined %d times>", this.myVersionSourceBindings.size()) : this.myVersion);
        return buffer.toString();
    }
}

