/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.java;

import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.java.LanguageLevelUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class JavaVersionDslElement
extends GradleDslElement {
    private String myText;
    private LanguageLevel myUnsavedValue;

    public JavaVersionDslElement(GradleDslElement parent, GrExpression psiElement, String name) {
        super(parent, (GroovyPsiElement)psiElement, name);
        if (psiElement != null) {
            this.myText = psiElement.getText();
        }
    }

    public JavaVersionDslElement(GradleDslElement parent, String name) {
        this(parent, (GrExpression)null, name);
    }

    @Override
    public void setPsiElement(GroovyPsiElement psiElement) {
        super.setPsiElement(psiElement);
        if (psiElement != null) {
            this.myText = psiElement.getText();
        }
    }

    public GrExpression getPsiElement() {
        return (GrExpression)super.getPsiElement();
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return Collections.emptyList();
    }

    public LanguageLevel getVersion() {
        if (this.myText != null) {
            return LanguageLevelUtil.parseFromGradleString(this.myText);
        }
        return null;
    }

    public void setVersion(LanguageLevel languageLevel) {
        this.myUnsavedValue = languageLevel;
        this.setModified(true);
    }

    @Override
    protected void apply() {
        if (this.myUnsavedValue == null || this.getPsiElement() == null) {
            return;
        }
        String groovyString = LanguageLevelUtil.convertToGradleString(this.myUnsavedValue, this.myText);
        GrExpression expression = GroovyPsiElementFactory.getInstance((Project)this.getPsiElement().getProject()).createExpressionFromText((CharSequence)groovyString);
        this.setPsiElement((GroovyPsiElement)((GrExpression)this.getPsiElement().replace((PsiElement)expression)));
    }

    @Override
    protected void reset() {
        this.myUnsavedValue = null;
    }

    @Override
    public GroovyPsiElement create() {
        JavaDslElement java = (JavaDslElement)this.myParent;
        assert (java != null);
        GroovyPsiElement javaPsiElement = java.create();
        assert (javaPsiElement != null);
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)javaPsiElement.getProject());
        GrExpression anchor = null;
        GrExpression value = null;
        JavaVersionDslElement javaVersionElement = java.getProperty(JavaModel.SOURCE_COMPATIBILITY_FIELD, JavaVersionDslElement.class);
        if (javaVersionElement != null) {
            anchor = javaVersionElement.getPsiElement();
            value = javaVersionElement.getPsiElement();
        }
        if (anchor == null && (javaVersionElement = java.getProperty(JavaModel.TARGET_COMPATIBILITY_FIELD, JavaVersionDslElement.class)) != null) {
            anchor = javaVersionElement.getPsiElement();
            value = javaVersionElement.getPsiElement();
        }
        if (anchor == null) {
            anchor = javaPsiElement.getLastChild();
            value = factory.createLiteralFromValue((Object)"1.6");
        }
        GrAssignmentExpression expression = (GrAssignmentExpression)factory.createExpressionFromText((CharSequence)(this.myName + " = " + value.getText()));
        GrAssignmentExpression added = (GrAssignmentExpression)javaPsiElement.addAfter((PsiElement)expression, anchor == null ? null : anchor.getParent());
        this.setPsiElement((GroovyPsiElement)added.getRValue());
        return this.getPsiElement();
    }

    @Override
    protected void delete() {
        GrExpression psiElement = this.getPsiElement();
        if (psiElement == null) {
            return;
        }
        if (psiElement.getParent() != null) {
            psiElement.getParent().delete();
        }
    }
}

