/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralMap;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public abstract class GradlePropertiesDslElement
extends GradleDslElement {
    protected Map<String, GradleDslElement> myProperties = Maps.newHashMap();
    protected Map<String, GradleDslElement> myToBeAddedProperties = Maps.newHashMap();
    protected Set<String> myToBeRemovedProperties = Sets.newHashSet();

    protected GradlePropertiesDslElement(GradleDslElement parent, GroovyPsiElement psiElement, String name) {
        super(parent, psiElement, name);
    }

    public void setDslElement(String property, GradleDslElement element) {
        this.myProperties.put(property, element);
    }

    public void addDslElement(String property, GradleDslElement element) {
        this.myProperties.put(property, element);
    }

    protected void addAsDslLiteralList(String property, GradleDslLiteral dslLiteral) {
        GroovyPsiElement psiElement = dslLiteral.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslLiteralList literalList = new GradleDslLiteralList(this, psiElement, property, dslLiteral.getLiteral());
        this.myProperties.put(property, literalList);
    }

    public void addToDslLiteralList(String property, GradleDslElement element) {
        GroovyPsiElement psiElement = element.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GrLiteral[] literalsToAdd = null;
        if (element instanceof GradleDslLiteral) {
            literalsToAdd = new GrLiteral[]{((GradleDslLiteral)element).getLiteral()};
        } else if (element instanceof GradleDslLiteralList) {
            List<GradleDslLiteral> gradleDslLiterals = ((GradleDslLiteralList)element).getElements();
            literalsToAdd = new GrLiteral[gradleDslLiterals.size()];
            for (int i = 0; i < gradleDslLiterals.size(); ++i) {
                literalsToAdd[i] = gradleDslLiterals.get(i).getLiteral();
            }
        }
        if (literalsToAdd == null) {
            return;
        }
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            gradleDslLiteralList.add(psiElement, property, literalsToAdd);
            return;
        }
        gradleDslLiteralList = new GradleDslLiteralList(this, psiElement, property, literalsToAdd);
        this.myProperties.put(property, gradleDslLiteralList);
    }

    public GradlePropertiesDslElement setNewElement(String property, GradleDslElement newElement) {
        this.myToBeAddedProperties.put(property, newElement);
        this.setModified(true);
        return this;
    }

    public Collection<String> getProperties() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.myProperties.keySet());
        result.addAll(this.myToBeAddedProperties.keySet());
        result.removeAll(this.myToBeRemovedProperties);
        return result;
    }

    public GradleDslElement getPropertyElement(String property) {
        if (!property.contains(".")) {
            if (this.myToBeRemovedProperties.contains(property)) {
                return null;
            }
            GradleDslElement toBeAddedElement = this.myToBeAddedProperties.get(property);
            return toBeAddedElement != null ? toBeAddedElement : this.myProperties.get(property);
        }
        List propertyNameSegments = Splitter.on((char)'.').splitToList((CharSequence)property);
        GradlePropertiesDslElement nestedElement = this;
        for (int i = 0; i < propertyNameSegments.size() - 1; ++i) {
            GradleDslElement element = nestedElement.getPropertyElement((String)propertyNameSegments.get(i));
            if (!(element instanceof GradlePropertiesDslElement)) {
                return null;
            }
            nestedElement = (GradlePropertiesDslElement)element;
        }
        return nestedElement.getPropertyElement((String)propertyNameSegments.get(propertyNameSegments.size() - 1));
    }

    public <T> T getProperty(String property, Class<T> clazz) {
        GradleDslElement propertyElement = this.getPropertyElement(property);
        if (propertyElement != null) {
            if (clazz.isInstance(propertyElement)) {
                return clazz.cast(propertyElement);
            }
            if (propertyElement instanceof GradleDslLiteral) {
                return ((GradleDslLiteral)propertyElement).getValue(clazz);
            }
        }
        return null;
    }

    public GradlePropertiesDslElement setLiteralProperty(String property, String value) {
        return this.setLiteralPropertyImpl(property, value);
    }

    public GradlePropertiesDslElement setLiteralProperty(String property, Integer value) {
        return this.setLiteralPropertyImpl(property, value);
    }

    public GradlePropertiesDslElement setLiteralProperty(String property, Boolean value) {
        return this.setLiteralPropertyImpl(property, value);
    }

    private GradlePropertiesDslElement setLiteralPropertyImpl(String property, Object value) {
        GradleDslLiteral literalElement = this.getProperty(property, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, property);
            this.myToBeAddedProperties.put(property, literalElement);
        }
        literalElement.setValue(value);
        return this;
    }

    public GradlePropertiesDslElement addToListProperty(String property, String value) {
        return this.addToListPropertyImpl(property, value);
    }

    public GradlePropertiesDslElement removeFromListProperty(String property, String value) {
        return this.removeFromListPropertyImpl(property, value);
    }

    public GradlePropertiesDslElement replaceInListProperty(String property, String oldValue, String newValue) {
        return this.replaceInListPropertyImpl(property, oldValue, newValue);
    }

    private GradlePropertiesDslElement addToListPropertyImpl(String property, Object value) {
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList == null) {
            gradleDslLiteralList = new GradleDslLiteralList(this, property);
            this.myToBeAddedProperties.put(property, gradleDslLiteralList);
        }
        gradleDslLiteralList.add(value);
        return this;
    }

    private GradlePropertiesDslElement removeFromListPropertyImpl(String property, Object value) {
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            gradleDslLiteralList.remove(value);
        }
        return this;
    }

    private GradlePropertiesDslElement replaceInListPropertyImpl(String property, Object oldValue, Object newValue) {
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            gradleDslLiteralList.replace(oldValue, newValue);
        }
        return this;
    }

    public GradlePropertiesDslElement setInMapProperty(String property, String name, String value) {
        return this.setInMapPropertyImpl(property, name, value);
    }

    public GradlePropertiesDslElement setInMapProperty(String property, String name, Integer value) {
        return this.setInMapPropertyImpl(property, name, value);
    }

    public GradlePropertiesDslElement setInMapProperty(String property, String name, Boolean value) {
        return this.setInMapPropertyImpl(property, name, value);
    }

    private GradlePropertiesDslElement setInMapPropertyImpl(String property, String name, Object value) {
        GradleDslLiteralMap gradleDslLiteralMap = this.getProperty(property, GradleDslLiteralMap.class);
        if (gradleDslLiteralMap == null) {
            gradleDslLiteralMap = new GradleDslLiteralMap(this, property);
            this.myToBeAddedProperties.put(property, gradleDslLiteralMap);
        }
        gradleDslLiteralMap.put(name, value);
        return this;
    }

    public GradlePropertiesDslElement removeFromMapProperty(String property, String name) {
        GradleDslLiteralMap gradleDslLiteralMap = this.getProperty(property, GradleDslLiteralMap.class);
        if (gradleDslLiteralMap != null) {
            gradleDslLiteralMap.removeProperty(name);
        }
        return this;
    }

    public void removeProperty(String property) {
        this.myToBeRemovedProperties.add(property);
        this.setModified(true);
    }

    public <E> List<E> getListProperty(String property, Class<E> clazz) {
        GradleDslLiteralList gradleDslLiteralList = this.getProperty(property, GradleDslLiteralList.class);
        if (gradleDslLiteralList != null) {
            return gradleDslLiteralList.getValues(clazz);
        }
        return null;
    }

    public <V> Map<String, V> getMapProperty(String property, Class<V> clazz) {
        GradleDslLiteralMap gradleDslLiteralMap = this.getProperty(property, GradleDslLiteralMap.class);
        if (gradleDslLiteralMap != null) {
            return gradleDslLiteralMap.getValues(clazz);
        }
        return null;
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        ArrayList children = Lists.newArrayList();
        for (String property : this.getProperties()) {
            GradleDslElement element = this.getPropertyElement(property);
            if (element == null) continue;
            children.add(element);
        }
        return children;
    }

    @Override
    protected void apply() {
        for (Map.Entry<String, GradleDslElement> entry : this.myToBeAddedProperties.entrySet()) {
            String property = entry.getKey();
            GradleDslElement element = entry.getValue();
            if (element.create() == null) continue;
            this.setDslElement(property, element);
        }
        this.myToBeAddedProperties.clear();
        for (String property : this.myToBeRemovedProperties) {
            GradleDslElement element = this.myProperties.remove(property);
            if (element == null) continue;
            element.delete();
        }
        this.myToBeRemovedProperties.clear();
        for (GradleDslElement element : this.myProperties.values()) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeRemovedProperties.clear();
        this.myToBeAddedProperties.clear();
        for (GradleDslElement element : this.myProperties.values()) {
            if (!element.isModified()) continue;
            element.resetState();
        }
    }

    protected void clear() {
        this.myToBeRemovedProperties.clear();
        this.myToBeAddedProperties.clear();
        this.myProperties.clear();
    }
}

