/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public final class GradleDslLiteralList
extends GradleDslElement {
    private final List<GradleDslLiteral> myElements = Lists.newArrayList();
    private final List<GradleDslLiteral> myToBeAddedElements = Lists.newArrayList();
    private final List<GradleDslLiteral> myToBeRemovedElements = Lists.newArrayList();

    public GradleDslLiteralList(GradleDslElement parent, String name) {
        super(parent, null, name);
    }

    public GradleDslLiteralList(GradleDslElement parent, String name, GrListOrMap list) {
        super(parent, (GroovyPsiElement)list, name);
        assert (!list.isMap());
        for (GrExpression exp : list.getInitializers()) {
            if (!(exp instanceof GrLiteral)) continue;
            this.myElements.add(new GradleDslLiteral(this, (GroovyPsiElement)list, name, (GrLiteral)exp));
        }
    }

    public GradleDslLiteralList(GradleDslElement parent, GroovyPsiElement psiElement, String name, GrLiteral ... literals) {
        super(parent, psiElement, name);
        for (GrLiteral literal : literals) {
            this.myElements.add(new GradleDslLiteral(this, psiElement, name, literal));
        }
    }

    void add(GroovyPsiElement psiElement, String name, GrLiteral ... literals) {
        this.setPsiElement(psiElement);
        for (GrLiteral literal : literals) {
            this.myElements.add(new GradleDslLiteral(this, psiElement, name, literal));
        }
    }

    public List<GradleDslLiteral> getElements() {
        if (this.myToBeAddedElements.isEmpty() && this.myToBeRemovedElements.isEmpty()) {
            return ImmutableList.copyOf(this.myElements);
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myElements);
        result.addAll(this.myToBeAddedElements);
        for (GradleDslLiteral element : this.myToBeRemovedElements) {
            result.remove(element);
        }
        return result;
    }

    public void add(GradleDslLiteral ... elements) {
        this.myToBeAddedElements.addAll(Arrays.asList(elements));
        this.setModified(true);
    }

    void add(Object elementValue) {
        GradleDslLiteral element = new GradleDslLiteral(this, this.myName);
        element.setValue(elementValue);
        this.myToBeAddedElements.add(element);
    }

    void remove(Object elementValue) {
        for (GradleDslLiteral element : this.getElements()) {
            if (!elementValue.equals(element.getValue())) continue;
            this.myToBeRemovedElements.add(element);
            this.setModified(true);
            return;
        }
    }

    void replace(Object oldElementValue, Object newElementValue) {
        for (GradleDslLiteral element : this.getElements()) {
            if (!oldElementValue.equals(element.getValue())) continue;
            element.setValue(newElementValue);
            return;
        }
    }

    public <E> List<E> getValues(Class<E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (GradleDslLiteral element : this.getElements()) {
            E value = element.getValue(clazz);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public GroovyPsiElement create() {
        GroovyPsiElement psiElement = super.create();
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrArgumentList) {
            if (((GrArgumentList)psiElement).getAllArguments().length == 1) {
                this.setPsiElement(null);
                psiElement = super.create();
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                this.setPsiElement((GroovyPsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    protected void apply() {
        GroovyPsiElement psiElement = this.create();
        if (psiElement != null) {
            for (GradleDslLiteral element : this.myToBeAddedElements) {
                element.setPsiElement(psiElement);
                element.applyChanges();
                this.myElements.add(element);
            }
        }
        this.myToBeAddedElements.clear();
        for (GradleDslLiteral element : this.myToBeRemovedElements) {
            if (!this.myElements.remove(element)) continue;
            element.delete();
        }
        this.myToBeRemovedElements.clear();
        for (GradleDslLiteral element : this.myElements) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedElements.clear();
        this.myToBeRemovedElements.clear();
        for (GradleDslLiteral element : this.myElements) {
            if (!element.isModified()) continue;
            element.resetState();
        }
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }
}

