/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public class GradleDslElementList
extends GradleDslElement {
    private final List<GradleDslElement> myElements = Lists.newArrayList();
    private final List<GradleDslElement> myToBeAddedElements = Lists.newArrayList();
    private final List<GradleDslElement> myToBeRemovedElements = Lists.newArrayList();

    public GradleDslElementList(GradleDslElement parent, String name) {
        super(parent, null, name);
    }

    public void addParsedElement(GradleDslElement element) {
        this.myElements.add(element);
    }

    public void addNewElement(GradleDslElement element) {
        this.myToBeAddedElements.add(element);
        this.setModified(true);
    }

    public void removeElement(GradleDslElement element) {
        if (this.myElements.contains(element)) {
            this.myToBeRemovedElements.add(element);
            this.setModified(true);
        }
    }

    public List<GradleDslElement> getElements() {
        if (this.myToBeAddedElements.isEmpty() && this.myToBeRemovedElements.isEmpty()) {
            return ImmutableList.copyOf(this.myElements);
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myElements);
        result.addAll(this.myToBeAddedElements);
        for (GradleDslElement element : this.myToBeRemovedElements) {
            result.remove(element);
        }
        return result;
    }

    public <E extends GradleDslElement> List<E> getElements(Class<E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement element : this.getElements()) {
            if (!clazz.isInstance(element)) continue;
            result.add(clazz.cast(element));
        }
        return result;
    }

    @Override
    public GroovyPsiElement getPsiElement() {
        return null;
    }

    @Override
    public GroovyPsiElement create() {
        return this.myParent == null ? null : this.myParent.create();
    }

    @Override
    public void setPsiElement(GroovyPsiElement psiElement) {
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.copyOf(this.getElements());
    }

    @Override
    protected void apply() {
        for (GradleDslElement element : this.myToBeAddedElements) {
            if (element.create() == null) continue;
            this.myElements.add(element);
        }
        this.myToBeAddedElements.clear();
        for (GradleDslElement element : this.myToBeRemovedElements) {
            if (!this.myElements.remove(element)) continue;
            element.delete();
        }
        this.myToBeRemovedElements.clear();
        for (GradleDslElement element : this.myElements) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedElements.clear();
        this.myToBeRemovedElements.clear();
    }
}

