/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser;

import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.google.common.base.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class GradleDslParser {
    public static boolean parse(GroovyPsiElement psiElement, GradleDslFile gradleDslFile) {
        if (psiElement instanceof GrMethodCallExpression) {
            return GradleDslParser.parse((GrMethodCallExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        }
        if (psiElement instanceof GrAssignmentExpression) {
            return GradleDslParser.parse((GrAssignmentExpression)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        }
        if (psiElement instanceof GrApplicationStatement) {
            return GradleDslParser.parse((GrApplicationStatement)psiElement, (GradlePropertiesDslElement)gradleDslFile);
        }
        return false;
    }

    private static boolean parse(GrMethodCallExpression expression, GradlePropertiesDslElement dslElement) {
        GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)expression, GrReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        GrClosableBlock[] closureArguments = expression.getClosureArguments();
        if (closureArguments.length == 0) {
            return false;
        }
        GrClosableBlock closableBlock = closureArguments[0];
        String blockName = referenceExpression.getText();
        if (StringUtil.isEmpty((String)blockName)) {
            return false;
        }
        List nameSegments = Splitter.on((char)'.').splitToList((CharSequence)blockName);
        GradlePropertiesDslElement blockElement = GradleDslParser.getElement(nameSegments, dslElement);
        if (blockElement == null) {
            return false;
        }
        blockElement.setPsiElement((GroovyPsiElement)closableBlock);
        GradleDslParser.parse(closableBlock, blockElement);
        return true;
    }

    private static void parse(GrClosableBlock closure, final GradlePropertiesDslElement blockElement) {
        closure.acceptChildren(new GroovyElementVisitor(){

            public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
                GradleDslParser.parse(methodCallExpression, blockElement);
            }

            public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
                GradleDslParser.parse(applicationStatement, blockElement);
            }

            public void visitAssignmentExpression(GrAssignmentExpression expression) {
                GradleDslParser.parse(expression, blockElement);
            }
        });
    }

    private static boolean parse(GrApplicationStatement statement, GradlePropertiesDslElement blockElement) {
        GrReferenceExpression referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, GrReferenceExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        GrCommandArgumentList argumentList = (GrCommandArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)referenceExpression, GrCommandArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 0) {
            return false;
        }
        String name = referenceExpression.getText();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        List nameSegments = Splitter.on((char)'.').splitToList((CharSequence)name);
        if (nameSegments.size() > 1) {
            GradlePropertiesDslElement nestedElement = GradleDslParser.getElement(nameSegments.subList(0, nameSegments.size() - 1), blockElement);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        String propertyName = (String)nameSegments.get(nameSegments.size() - 1);
        GradleDslElement propertyElement = null;
        if (arguments.length == 1) {
            GroovyPsiElement element = arguments[0];
            if (element instanceof GrLiteral) {
                propertyElement = new GradleDslLiteral(blockElement, (GroovyPsiElement)argumentList, propertyName, (GrLiteral)element);
            } else if (element instanceof GrNamedArgument) {
                GrNamedArgument namedArgument = (GrNamedArgument)element;
                propertyElement = new GradleDslLiteralMap(blockElement, (GroovyPsiElement)argumentList, propertyName, namedArgument);
            }
        } else if (arguments[0] instanceof GrLiteral) {
            GrLiteral[] literals = new GrLiteral[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                literals[i] = (GrLiteral)arguments[i];
            }
            propertyElement = new GradleDslLiteralList(blockElement, (GroovyPsiElement)argumentList, propertyName, literals);
        } else if (arguments[0] instanceof GrNamedArgument) {
            GrNamedArgument[] namedArguments = new GrNamedArgument[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                namedArguments[i] = (GrNamedArgument)arguments[i];
            }
            propertyElement = new GradleDslLiteralMap(blockElement, (GroovyPsiElement)argumentList, propertyName, namedArguments);
        }
        if (propertyElement == null) {
            return false;
        }
        blockElement.addDslElement(propertyName, propertyElement);
        return true;
    }

    private static boolean parse(GrAssignmentExpression assignment, GradlePropertiesDslElement blockElement) {
        PsiElement operationToken = assignment.getOperationToken();
        if (!operationToken.getText().equals("=")) {
            return false;
        }
        GrExpression left = assignment.getLValue();
        String name = left.getText();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        List nameSegments = Splitter.on((char)'.').splitToList((CharSequence)name);
        if (nameSegments.size() > 1) {
            GradlePropertiesDslElement nestedElement = GradleDslParser.getElement(nameSegments.subList(0, nameSegments.size() - 1), blockElement);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        String propertyName = (String)nameSegments.get(nameSegments.size() - 1);
        GradleDslElement propertyElement = null;
        GrExpression right = assignment.getRValue();
        if (right instanceof GrLiteral) {
            propertyElement = new GradleDslLiteral(blockElement, (GroovyPsiElement)assignment, propertyName, (GrLiteral)right);
        } else if (right instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)right;
            propertyElement = listOrMap.isMap() ? new GradleDslLiteralMap((GradleDslElement)blockElement, propertyName, listOrMap) : new GradleDslLiteralList((GradleDslElement)blockElement, propertyName, listOrMap);
        }
        if (propertyElement == null) {
            return false;
        }
        blockElement.setDslElement(propertyName, propertyElement);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GradlePropertiesDslElement getElement(List<String> qualifiedName, GradlePropertiesDslElement parentElement) {
        GradlePropertiesDslElement resultElement = parentElement;
        for (String nestedElementName : qualifiedName) {
            GradleDslElement element = resultElement.getPropertyElement(nestedElementName);
            if (element == null) {
                void var6_6;
                if (resultElement instanceof GradleDslFile) {
                    if ("ext".equals(nestedElementName)) {
                        ExtDslElement extDslElement = new ExtDslElement(resultElement);
                    } else {
                        if (!"android".equals(nestedElementName)) return null;
                        AndroidDslElement androidDslElement = new AndroidDslElement(resultElement);
                    }
                } else if (resultElement instanceof AndroidDslElement) {
                    if ("defaultConfig".equals(nestedElementName)) {
                        ProductFlavorDslElement productFlavorDslElement = new ProductFlavorDslElement(resultElement, nestedElementName);
                    } else {
                        if (!"productFlavors".equals(nestedElementName)) return null;
                        ProductFlavorsDslElement productFlavorsDslElement = new ProductFlavorsDslElement(resultElement);
                    }
                } else if (resultElement instanceof ProductFlavorsDslElement) {
                    ProductFlavorDslElement productFlavorDslElement = new ProductFlavorDslElement(resultElement, nestedElementName);
                } else {
                    if (!(resultElement instanceof ProductFlavorDslElement) || !"manifestPlaceholders".equals(nestedElementName) && !"testInstrumentationRunnerArguments".equals(nestedElementName)) return null;
                    GradleDslLiteralMap gradleDslLiteralMap = new GradleDslLiteralMap(resultElement, nestedElementName);
                }
                resultElement.setDslElement(nestedElementName, (GradleDslElement)var6_6);
                resultElement = var6_6;
                continue;
            }
            if (!(element instanceof GradlePropertiesDslElement)) return null;
            resultElement = (GradlePropertiesDslElement)element;
        }
        return resultElement;
    }
}

