/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteralList;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ProductFlavorModel {
    private static final String APPLICATION_ID = "applicationId";
    private static final String CONSUMER_PROGUARD_FILES = "consumerProguardFiles";
    private static final String DIMENSION = "dimension";
    private static final String MANIFEST_PLACEHOLDERS = "manifestPlaceholders";
    private static final String MAX_SDK_VERSION = "maxSdkVersion";
    private static final String MIN_SDK_VERSION = "minSdkVersion";
    private static final String MULTI_DEX_ENABLED = "multiDexEnabled";
    private static final String PROGUARD_FILES = "proguardFiles";
    private static final String RES_CONFIGS = "resConfigs";
    private static final String RES_VALUES = "resValues";
    private static final String TARGET_SDK_VERSION = "targetSdkVersion";
    private static final String TEST_APPLICATION_ID = "testApplicationId";
    private static final String TEST_FUNCTIONAL_TEST = "testFunctionalTest";
    private static final String TEST_HANDLE_PROFILING = "testHandleProfiling";
    private static final String TEST_INSTRUMENTATION_RUNNER = "testInstrumentationRunner";
    private static final String TEST_INSTRUMENTATION_RUNNER_ARGUMENTS = "testInstrumentationRunnerArguments";
    private static final String USE_JACK = "useJack";
    private static final String VERSION_CODE = "versionCode";
    private static final String VERSION_NAME = "versionName";
    private final ProductFlavorDslElement myDslElement;

    public ProductFlavorModel(ProductFlavorDslElement dslElement) {
        this.myDslElement = dslElement;
    }

    public String name() {
        return this.myDslElement.getName();
    }

    public String applicationId() {
        return this.myDslElement.getProperty(APPLICATION_ID, String.class);
    }

    public ProductFlavorModel setApplicationId(String applicationId) {
        this.myDslElement.setLiteralProperty(APPLICATION_ID, applicationId);
        return this;
    }

    public ProductFlavorModel removeApplicationId() {
        this.myDslElement.removeProperty(APPLICATION_ID);
        return this;
    }

    public List<String> consumerProguardFiles() {
        return this.myDslElement.getListProperty(CONSUMER_PROGUARD_FILES, String.class);
    }

    public ProductFlavorModel addConsumerProguardFile(String consumerProguardFile) {
        this.myDslElement.addToListProperty(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        return this;
    }

    public ProductFlavorModel removeConsumerProguardFile(String consumerProguardFile) {
        this.myDslElement.removeFromListProperty(CONSUMER_PROGUARD_FILES, consumerProguardFile);
        return this;
    }

    public ProductFlavorModel removeAllConsumerProguardFiles() {
        this.myDslElement.removeProperty(CONSUMER_PROGUARD_FILES);
        return this;
    }

    public ProductFlavorModel replaceConsumerProguardFile(String oldConsumerProguardFile, String newConsumerProguardFile) {
        this.myDslElement.replaceInListProperty(CONSUMER_PROGUARD_FILES, oldConsumerProguardFile, newConsumerProguardFile);
        return this;
    }

    public String dimension() {
        return this.myDslElement.getProperty(DIMENSION, String.class);
    }

    public ProductFlavorModel setDimension(String dimension) {
        this.myDslElement.setLiteralProperty(DIMENSION, dimension);
        return this;
    }

    public ProductFlavorModel removeDimension() {
        this.myDslElement.removeProperty(DIMENSION);
        return this;
    }

    public Map<String, Object> manifestPlaceholders() {
        return this.myDslElement.getMapProperty(MANIFEST_PLACEHOLDERS, Object.class);
    }

    public ProductFlavorModel setManifestPlaceholder(String name, String value) {
        this.myDslElement.setInMapProperty(MANIFEST_PLACEHOLDERS, name, value);
        return this;
    }

    public ProductFlavorModel setManifestPlaceholder(String name, int value) {
        this.myDslElement.setInMapProperty(MANIFEST_PLACEHOLDERS, name, value);
        return this;
    }

    public ProductFlavorModel setManifestPlaceholder(String name, boolean value) {
        this.myDslElement.setInMapProperty(MANIFEST_PLACEHOLDERS, name, value);
        return this;
    }

    public ProductFlavorModel removeManifestPlaceholder(String name) {
        this.myDslElement.removeFromMapProperty(MANIFEST_PLACEHOLDERS, name);
        return this;
    }

    public ProductFlavorModel removeAllManifestPlaceholders() {
        this.myDslElement.removeProperty(MANIFEST_PLACEHOLDERS);
        return this;
    }

    public Integer maxSdkVersion() {
        return this.myDslElement.getProperty(MAX_SDK_VERSION, Integer.class);
    }

    public ProductFlavorModel setMaxSdkVersion(int maxSdkVersion) {
        this.myDslElement.setLiteralProperty(MAX_SDK_VERSION, maxSdkVersion);
        return this;
    }

    public ProductFlavorModel removeMaxSdkVersion() {
        this.myDslElement.removeProperty(MAX_SDK_VERSION);
        return this;
    }

    public String minSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(MIN_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(MIN_SDK_VERSION, String.class);
    }

    public ProductFlavorModel setMinSdkVersion(int minSdkVersion) {
        this.myDslElement.setLiteralProperty(MIN_SDK_VERSION, minSdkVersion);
        return this;
    }

    public ProductFlavorModel setMinSdkVersion(String minSdkVersion) {
        this.myDslElement.setLiteralProperty(MIN_SDK_VERSION, minSdkVersion);
        return this;
    }

    public ProductFlavorModel removeMinSdkVersion() {
        this.myDslElement.removeProperty(MIN_SDK_VERSION);
        return this;
    }

    public Boolean multiDexEnabled() {
        return this.myDslElement.getProperty(MULTI_DEX_ENABLED, Boolean.class);
    }

    public ProductFlavorModel setMultiDexEnabled(boolean multiDexEnabled) {
        this.myDslElement.setLiteralProperty(MULTI_DEX_ENABLED, multiDexEnabled);
        return this;
    }

    public ProductFlavorModel removeMultiDexEnabled() {
        this.myDslElement.removeProperty(MULTI_DEX_ENABLED);
        return this;
    }

    public List<String> proguardFiles() {
        return this.myDslElement.getListProperty(PROGUARD_FILES, String.class);
    }

    public ProductFlavorModel addProguardFile(String proguardFile) {
        this.myDslElement.addToListProperty(PROGUARD_FILES, proguardFile);
        return this;
    }

    public ProductFlavorModel removeProguardFile(String proguardFile) {
        this.myDslElement.removeFromListProperty(PROGUARD_FILES, proguardFile);
        return this;
    }

    public ProductFlavorModel removeAllProguardFiles() {
        this.myDslElement.removeProperty(PROGUARD_FILES);
        return this;
    }

    public ProductFlavorModel replaceProguardFile(String oldProguardFile, String newProguardFile) {
        this.myDslElement.replaceInListProperty(PROGUARD_FILES, oldProguardFile, newProguardFile);
        return this;
    }

    public List<String> resConfigs() {
        return this.myDslElement.getListProperty(RES_CONFIGS, String.class);
    }

    public ProductFlavorModel addResConfig(String resConfig) {
        this.myDslElement.addToListProperty(RES_CONFIGS, resConfig);
        return this;
    }

    public ProductFlavorModel removeResConfig(String resConfig) {
        this.myDslElement.removeFromListProperty(RES_CONFIGS, resConfig);
        return this;
    }

    public ProductFlavorModel removeAllResConfigs() {
        this.myDslElement.removeProperty(RES_CONFIGS);
        return this;
    }

    public ProductFlavorModel replaceResConfig(String oldResConfig, String newResConfig) {
        this.myDslElement.replaceInListProperty(RES_CONFIGS, oldResConfig, newResConfig);
        return this;
    }

    public List<ResValue> resValues() {
        GradleDslElementList resValues = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (resValues == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement resValue : resValues.getElements()) {
            GradleDslLiteralList listElement;
            List<String> values;
            if (!(resValue instanceof GradleDslLiteralList) || (values = (listElement = (GradleDslLiteralList)resValue).getValues(String.class)).size() != 3) continue;
            result.add(new ResValue(values.get(0), values.get(1), values.get(2)));
        }
        return result;
    }

    public ProductFlavorModel addResValue(ResValue resValue) {
        GradleDslElementList elementList = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (elementList == null) {
            elementList = new GradleDslElementList(this.myDslElement, RES_VALUES);
            this.myDslElement.setNewElement(RES_VALUES, elementList);
        }
        elementList.addNewElement(resValue.toLiteralListElement(this.myDslElement));
        return this;
    }

    public ProductFlavorModel removeResValue(ResValue resValue) {
        GradleDslElementList elementList = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (elementList != null) {
            for (GradleDslLiteralList element : elementList.getElements(GradleDslLiteralList.class)) {
                List<String> values = element.getValues(String.class);
                if (values.size() != 3 || !resValue.type().equals(values.get(0)) || !resValue.name().equals(values.get(1)) || !resValue.value().equals(values.get(2))) continue;
                elementList.removeElement(element);
            }
        }
        return this;
    }

    public ProductFlavorModel removeAllResValues() {
        this.myDslElement.removeProperty(RES_VALUES);
        return this;
    }

    public ProductFlavorModel replaceResValue(ResValue oldResValue, ResValue newResValue) {
        GradleDslElementList elementList = this.myDslElement.getProperty(RES_VALUES, GradleDslElementList.class);
        if (elementList != null) {
            for (GradleDslLiteralList element : elementList.getElements(GradleDslLiteralList.class)) {
                List<GradleDslLiteral> gradleDslLiterals = element.getElements();
                if (gradleDslLiterals.size() != 3 || !oldResValue.type().equals(gradleDslLiterals.get(0).getValue()) || !oldResValue.name().equals(gradleDslLiterals.get(1).getValue()) || !oldResValue.value().equals(gradleDslLiterals.get(2).getValue())) continue;
                gradleDslLiterals.get(0).setValue(newResValue.type());
                gradleDslLiterals.get(1).setValue(newResValue.name());
                gradleDslLiterals.get(2).setValue(newResValue.value());
            }
        }
        return this;
    }

    public String targetSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(TARGET_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(TARGET_SDK_VERSION, String.class);
    }

    public ProductFlavorModel setTargetSdkVersion(int targetSdkVersion) {
        this.myDslElement.setLiteralProperty(TARGET_SDK_VERSION, targetSdkVersion);
        return this;
    }

    public ProductFlavorModel setTargetSdkVersion(String targetSdkVersion) {
        this.myDslElement.setLiteralProperty(TARGET_SDK_VERSION, targetSdkVersion);
        return this;
    }

    public ProductFlavorModel removeTargetSdkVersion() {
        this.myDslElement.removeProperty(TARGET_SDK_VERSION);
        return this;
    }

    public String testApplicationId() {
        return this.myDslElement.getProperty(TEST_APPLICATION_ID, String.class);
    }

    public ProductFlavorModel setTestApplicationId(String testApplicationId) {
        this.myDslElement.setLiteralProperty(TEST_APPLICATION_ID, testApplicationId);
        return this;
    }

    public ProductFlavorModel removeTestApplicationId() {
        this.myDslElement.removeProperty(TEST_APPLICATION_ID);
        return this;
    }

    public Boolean testFunctionalTest() {
        return this.myDslElement.getProperty(TEST_FUNCTIONAL_TEST, Boolean.class);
    }

    public ProductFlavorModel setTestFunctionalTest(boolean testFunctionalTest) {
        this.myDslElement.setLiteralProperty(TEST_FUNCTIONAL_TEST, testFunctionalTest);
        return this;
    }

    public ProductFlavorModel removeTestFunctionalTest() {
        this.myDslElement.removeProperty(TEST_FUNCTIONAL_TEST);
        return this;
    }

    public Boolean testHandleProfiling() {
        return this.myDslElement.getProperty(TEST_HANDLE_PROFILING, Boolean.class);
    }

    public ProductFlavorModel setTestHandleProfiling(boolean testHandleProfiling) {
        this.myDslElement.setLiteralProperty(TEST_HANDLE_PROFILING, testHandleProfiling);
        return this;
    }

    public ProductFlavorModel removeTestHandleProfiling() {
        this.myDslElement.removeProperty(TEST_HANDLE_PROFILING);
        return this;
    }

    public String testInstrumentationRunner() {
        return this.myDslElement.getProperty(TEST_INSTRUMENTATION_RUNNER, String.class);
    }

    public ProductFlavorModel setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.myDslElement.setLiteralProperty(TEST_INSTRUMENTATION_RUNNER, testInstrumentationRunner);
        return this;
    }

    public ProductFlavorModel removeTestInstrumentationRunner() {
        this.myDslElement.removeProperty(TEST_INSTRUMENTATION_RUNNER);
        return this;
    }

    public Map<String, String> testInstrumentationRunnerArguments() {
        return this.myDslElement.getMapProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, String.class);
    }

    public ProductFlavorModel setTestInstrumentationRunnerArgument(String name, String value) {
        this.myDslElement.setInMapProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, name, value);
        return this;
    }

    public ProductFlavorModel removeTestInstrumentationRunnerArgument(String name) {
        this.myDslElement.removeFromMapProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS, name);
        return this;
    }

    public ProductFlavorModel removeAllTestInstrumentationRunnerArguments() {
        this.myDslElement.removeProperty(TEST_INSTRUMENTATION_RUNNER_ARGUMENTS);
        return this;
    }

    public Boolean useJack() {
        return this.myDslElement.getProperty(USE_JACK, Boolean.class);
    }

    public ProductFlavorModel setUseJack(boolean useJack) {
        this.myDslElement.setLiteralProperty(USE_JACK, useJack);
        return this;
    }

    public ProductFlavorModel removeUseJack() {
        this.myDslElement.removeProperty(USE_JACK);
        return this;
    }

    public String versionCode() {
        Integer intValue = this.myDslElement.getProperty(VERSION_CODE, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(VERSION_CODE, String.class);
    }

    public ProductFlavorModel setVersionCode(int versionCode) {
        this.myDslElement.setLiteralProperty(VERSION_CODE, versionCode);
        return this;
    }

    public ProductFlavorModel setVersionCode(String versionCode) {
        this.myDslElement.setLiteralProperty(VERSION_CODE, versionCode);
        return this;
    }

    public ProductFlavorModel removeVersionCode() {
        this.myDslElement.removeProperty(VERSION_CODE);
        return this;
    }

    public String versionName() {
        return this.myDslElement.getProperty(VERSION_NAME, String.class);
    }

    public ProductFlavorModel setVersionName(String versionName) {
        this.myDslElement.setLiteralProperty(VERSION_NAME, versionName);
        return this;
    }

    public ProductFlavorModel removeVersionName() {
        this.myDslElement.removeProperty(VERSION_NAME);
        return this;
    }

    public static final class ResValue {
        public static final String NAME = "resValue";
        private final String myType;
        private final String myName;
        private final String myValue;

        public ResValue(String type, String name, String value) {
            this.myType = type;
            this.myName = name;
            this.myValue = value;
        }

        public String type() {
            return this.myType;
        }

        public String name() {
            return this.myName;
        }

        public String value() {
            return this.myValue;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myType, this.myName, this.myValue});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResValue)) {
                return false;
            }
            ResValue other = (ResValue)o;
            return this.myType.equals(other.myType) && this.myName.equals(other.myName) && this.myValue.equals(other.myValue);
        }

        public String toString() {
            return String.format("Type: %1$s, Name: %2$s, Value: %3$s", this.myType, this.myName, this.myValue);
        }

        private GradleDslLiteralList toLiteralListElement(GradleDslElement parent) {
            GradleDslLiteral typeElement = new GradleDslLiteral(parent, NAME);
            typeElement.setValue(this.myType);
            GradleDslLiteral nameElement = new GradleDslLiteral(parent, NAME);
            nameElement.setValue(this.myName);
            GradleDslLiteral valueElement = new GradleDslLiteral(parent, NAME);
            valueElement.setValue(this.myValue);
            GradleDslLiteralList gradleDslLiteralList = new GradleDslLiteralList(parent, NAME);
            gradleDslLiteralList.add(typeElement, nameElement, valueElement);
            return gradleDslLiteralList;
        }
    }
}

