/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;

public class GradleSettingsModel
extends GradleFileModel {
    private static final String INCLUDE = "include";

    public static GradleSettingsModel get(Project project) {
        VirtualFile file = GradleUtil.getGradleSettingsFile(Projects.getBaseDirPath(project));
        return file != null ? GradleSettingsModel.parseBuildFile(file, project, "settings") : null;
    }

    public static GradleSettingsModel parseBuildFile(VirtualFile file, Project project, String moduleName) {
        GradleSettingsDslFile settingsFile = new GradleSettingsDslFile(file, project, moduleName);
        settingsFile.parse();
        return new GradleSettingsModel(settingsFile);
    }

    private GradleSettingsModel(GradleSettingsDslFile parsedModel) {
        super(parsedModel);
    }

    public List<String> modulePaths() {
        return this.myGradleDslFile.getListProperty(INCLUDE, String.class);
    }

    public GradleSettingsModel addModulePath(String modulePath) {
        if (!modulePath.startsWith(":")) {
            modulePath = ":" + modulePath;
        }
        this.myGradleDslFile.addToListProperty(INCLUDE, modulePath);
        return this;
    }

    public GradleSettingsModel removeModulePath(String modulePath) {
        if (!modulePath.startsWith(":")) {
            this.myGradleDslFile.removeFromListProperty(INCLUDE, ":" + modulePath);
        }
        this.myGradleDslFile.removeFromListProperty(INCLUDE, modulePath);
        return this;
    }

    public GradleSettingsModel replaceModulePath(String oldModulePath, String newModulePath) {
        if (!newModulePath.startsWith(":")) {
            newModulePath = ":" + newModulePath;
        }
        if (!oldModulePath.startsWith(":")) {
            this.myGradleDslFile.replaceInListProperty(INCLUDE, ":" + oldModulePath, newModulePath);
        }
        this.myGradleDslFile.replaceInListProperty(INCLUDE, oldModulePath, newModulePath);
        return this;
    }

    private static class GradleSettingsDslFile
    extends GradleDslFile {
        private GradleSettingsDslFile(VirtualFile file, Project project, String moduleName) {
            super(file, project, moduleName);
        }

        @Override
        public void addDslElement(String property, GradleDslElement element) {
            if (property.equals(GradleSettingsModel.INCLUDE)) {
                this.addToDslLiteralList(property, element);
                return;
            }
            super.addDslElement(property, element);
        }
    }
}

