/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies.external;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

final class MapNotation
extends ExternalDependency {
    private static final String VERSION_PROPERTY = "version";
    private final Map<String, GrLiteral> myValueLiteralsByName;
    private final GrListOrMap myListOrMap;

    static MapNotation parse(Dependencies parent, GrMethodCall methodCall, String configurationName, GrNamedArgument[] namedArguments, GrListOrMap listOrMap) {
        HashMap valueLiteralsByName = Maps.newHashMap();
        HashMap valuesByName = Maps.newHashMap();
        for (GrNamedArgument argument : namedArguments) {
            GrLiteral literal = (GrLiteral)PsiTreeUtil.getChildOfType((PsiElement)argument, GrLiteral.class);
            if (literal == null) continue;
            String name = argument.getLabelName();
            valueLiteralsByName.put(name, literal);
            valuesByName.put(name, PsiElements.getUnquotedText(literal));
        }
        ExternalDependencySpec spec = MapNotation.parse(valuesByName);
        if (spec != null) {
            return new MapNotation(parent, methodCall, configurationName, spec, valueLiteralsByName, listOrMap);
        }
        return null;
    }

    @VisibleForTesting
    static ExternalDependencySpec parse(Map<String, String> valuesByName) {
        String name = valuesByName.get("name");
        if (StringUtil.isNotEmpty((String)name)) {
            return new ExternalDependencySpec(name, valuesByName.get("group"), valuesByName.get(VERSION_PROPERTY), valuesByName.get("classifier"), valuesByName.get("ext"));
        }
        return null;
    }

    private MapNotation(Dependencies parent, GrMethodCall methodCall, String configurationName, ExternalDependencySpec spec, Map<String, GrLiteral> valueLiteralsByName, GrListOrMap listOrMap) {
        super(parent, methodCall, configurationName, spec);
        this.myValueLiteralsByName = valueLiteralsByName;
        this.myListOrMap = listOrMap;
    }

    @Override
    protected void applyVersion(String newVersion) {
        GrLiteral literal = this.myValueLiteralsByName.get(VERSION_PROPERTY);
        this.mySpec.version = newVersion;
        if (literal != null) {
            GrLiteral newLiteral = PsiElements.setLiteralText(literal, newVersion);
            this.myValueLiteralsByName.put(VERSION_PROPERTY, newLiteral);
        }
    }

    @Override
    protected void removeFromParent() {
        GrClosableBlock closureBlock = this.getParent().getClosureBlock();
        assert (closureBlock != null);
        if (this.myListOrMap != null && this.removeArgumentIfMoreThanOne((GroovyPsiElement)this.myListOrMap)) {
            return;
        }
        closureBlock.removeElements(new PsiElement[]{this.getMethodCall()});
    }
}

