/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies.external;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.Dependency;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.external.CompactNotation;
import com.android.tools.idea.gradle.dsl.dependencies.external.MapNotation;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class ExternalDependency
extends Dependency {
    protected final ExternalDependencySpec mySpec;
    private String myNewVersion;

    protected ExternalDependency(Dependencies parent, GrMethodCall methodCall, String configurationName, ExternalDependencySpec spec) {
        super(parent, methodCall, configurationName);
        this.mySpec = spec;
    }

    public String group() {
        return this.mySpec.group;
    }

    public String name() {
        return this.mySpec.name;
    }

    public String version() {
        return this.mySpec.version;
    }

    public void version(String version) {
        this.myNewVersion = version;
        this.setModified(true);
    }

    public String classifier() {
        return this.mySpec.classifier;
    }

    public String extension() {
        return this.mySpec.extension;
    }

    public String compactNotation() {
        return this.mySpec.toString();
    }

    public ExternalDependencySpec spec() {
        return this.mySpec;
    }

    @Override
    protected void apply() {
        this.applyVersionChange();
    }

    private void applyVersionChange() {
        if (this.myNewVersion == null) {
            return;
        }
        this.applyVersion(this.myNewVersion);
        this.reset();
    }

    protected abstract void applyVersion(String var1);

    @Override
    protected void reset() {
        this.myNewVersion = null;
    }

    public static List<Dependency> parse(Dependencies parent, GrMethodCall methodCall, GrReferenceExpression configurationName, GroovyPsiElement[] arguments) {
        ExternalDependency dependency;
        if (arguments.length == 0) {
            return Collections.emptyList();
        }
        GroovyPsiElement first = arguments[0];
        if (first instanceof GrLiteral) {
            return ExternalDependency.parseCompactNotation(parent, methodCall, configurationName, arguments);
        }
        if (first instanceof GrNamedArgument && (dependency = ExternalDependency.parseMapNotation(parent, methodCall, configurationName, arguments)) != null) {
            return Collections.singletonList(dependency);
        }
        return Collections.emptyList();
    }

    private static List<Dependency> parseCompactNotation(Dependencies parent, GrMethodCall methodCall, GrReferenceExpression configurationName, GroovyPsiElement[] arguments) {
        ArrayList dependencies = Lists.newArrayList();
        for (GroovyPsiElement argument : arguments) {
            if (!(argument instanceof GrLiteral)) continue;
            GrLiteral literal = (GrLiteral)argument;
            CompactNotation dependency = CompactNotation.parse(parent, methodCall, configurationName.getText(), literal);
            if (dependency == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private static ExternalDependency parseMapNotation(Dependencies parent, GrMethodCall methodCall, GrReferenceExpression configurationName, GroovyPsiElement[] arguments) {
        ArrayList namedArguments = Lists.newArrayList();
        for (GroovyPsiElement argument : arguments) {
            if (!(argument instanceof GrNamedArgument)) continue;
            namedArguments.add((GrNamedArgument)argument);
        }
        if (namedArguments.isEmpty()) {
            return null;
        }
        GrNamedArgument[] namedArgumentArray = namedArguments.toArray(new GrNamedArgument[namedArguments.size()]);
        MapNotation dependency = MapNotation.parse(parent, methodCall, configurationName.getText(), namedArgumentArray, null);
        if (dependency != null) {
            return dependency;
        }
        return null;
    }

    public static List<Dependency> parse(Dependencies parent, GrMethodCallExpression expression) {
        GrReferenceExpression configurationName = ExternalDependency.findValidConfigurationNameExpression((GrMethodCall)expression);
        if (configurationName == null) {
            return Collections.emptyList();
        }
        GrArgumentList argumentList = expression.getArgumentList();
        ArrayList dependencies = Lists.newArrayList();
        for (GroovyPsiElement arg : argumentList.getAllArguments()) {
            MapNotation dependency;
            GrNamedArgument[] namedArgs;
            GrListOrMap listOrMap;
            if (!(arg instanceof GrListOrMap) || !(listOrMap = (GrListOrMap)arg).isMap() || (namedArgs = listOrMap.getNamedArguments()).length <= 0 || (dependency = MapNotation.parse(parent, (GrMethodCall)expression, configurationName.getText(), namedArgs, listOrMap)) == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    protected boolean removeArgumentIfMoreThanOne(GroovyPsiElement toRemove) {
        GrMethodCall methodCall = this.getMethodCall();
        GroovyPsiElement[] arguments = methodCall.getArgumentList().getAllArguments();
        if (arguments.length > 1) {
            ArrayList newArguments = Lists.newArrayList();
            for (GroovyPsiElement argument : arguments) {
                if (argument == toRemove) continue;
                newArguments.add(argument.getText());
            }
            if (!newArguments.isEmpty()) {
                String text = Joiner.on((char)',').join((Iterable)newArguments);
                if (toRemove instanceof GrListOrMap) {
                    text = '(' + text + ')';
                }
                Project project = toRemove.getProject();
                GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
                GrArgumentList newArgumentList = factory.createArgumentListFromText(text);
                methodCall.getArgumentList().replaceWithArgumentList(newArgumentList);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)methodCall);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.mySpec.toString();
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }
}

