/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies.external;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

final class CompactNotation
extends ExternalDependency {
    private final GrLiteral myValueLiteral;

    static CompactNotation parse(Dependencies parent, GrMethodCall methodCall, String configurationName, GrLiteral valueLiteral) {
        ExternalDependencySpec spec;
        String notation = PsiElements.getUnquotedText(valueLiteral);
        if (StringUtil.isNotEmpty((String)notation) && (spec = CompactNotation.parse(notation)) != null) {
            return new CompactNotation(parent, methodCall, configurationName, spec, valueLiteral);
        }
        return null;
    }

    @VisibleForTesting
    static ExternalDependencySpec parse(String notation) {
        List segments = Splitter.on((char)':').trimResults().omitEmptyStrings().splitToList((CharSequence)notation);
        int segmentCount = segments.size();
        if (segmentCount > 0) {
            segments = Lists.newArrayList((Iterable)segments);
            String lastSegment = (String)segments.remove(segmentCount - 1);
            String extension = null;
            int indexOfAt = lastSegment.indexOf(64);
            if (indexOfAt != -1) {
                extension = lastSegment.substring(indexOfAt + 1, lastSegment.length());
                lastSegment = lastSegment.substring(0, indexOfAt);
            }
            segments.add(lastSegment);
            segmentCount = segments.size();
            String group = null;
            String name = null;
            String version = null;
            String classifier = null;
            if (segmentCount == 1) {
                name = (String)segments.get(0);
            } else if (segmentCount == 2) {
                if (!lastSegment.isEmpty() && Character.isDigit(lastSegment.charAt(0))) {
                    name = (String)segments.get(0);
                    version = lastSegment;
                } else {
                    group = (String)segments.get(0);
                    name = (String)segments.get(1);
                }
            } else if (segmentCount == 3 || segmentCount == 4) {
                group = (String)segments.get(0);
                name = (String)segments.get(1);
                version = (String)segments.get(2);
                if (segmentCount == 4) {
                    classifier = (String)segments.get(3);
                }
            }
            if (StringUtil.isNotEmpty((String)name)) {
                return new ExternalDependencySpec(name, group, version, classifier, extension);
            }
        }
        return null;
    }

    private CompactNotation(Dependencies parent, GrMethodCall methodCall, String configurationName, ExternalDependencySpec spec, GrLiteral valueLiteral) {
        super(parent, methodCall, configurationName, spec);
        this.myValueLiteral = valueLiteral;
    }

    @Override
    protected void applyVersion(String newVersion) {
        this.mySpec.version = newVersion;
        PsiElements.setLiteralText(this.myValueLiteral, this.mySpec.toString());
    }

    @Override
    protected void removeFromParent() {
        GrClosableBlock closureBlock = this.getParent().getClosureBlock();
        assert (closureBlock != null);
        if (!this.removeArgumentIfMoreThanOne((GroovyPsiElement)this.myValueLiteral)) {
            closureBlock.removeElements(new PsiElement[]{this.getMethodCall()});
        }
    }
}

