/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.Dependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ModuleDependency
extends Dependency {
    GrLiteral myPathLiteral;
    GrLiteral myConfigurationLiteral;
    private String myNewName;

    public static ModuleDependency withCompactNotation(Dependencies parent, GrMethodCall methodCall, String configurationName, GrLiteral pathLiteral) {
        if (StringUtil.isEmpty((String)PsiElements.getUnquotedText(pathLiteral))) {
            return null;
        }
        return new ModuleDependency(parent, methodCall, configurationName, pathLiteral, null);
    }

    public static ModuleDependency withMapNotation(Dependencies parent, GrMethodCall methodCall, String configurationName, GrArgumentList argumentList) {
        GrLiteral pathLiteral = ModuleDependency.findNamedArgumentLiteralValue(argumentList, "path");
        if (pathLiteral == null || StringUtil.isEmpty((String)PsiElements.getUnquotedText(pathLiteral))) {
            return null;
        }
        return new ModuleDependency(parent, methodCall, configurationName, pathLiteral, ModuleDependency.findNamedArgumentLiteralValue(argumentList, "configuration"));
    }

    private static GrLiteral findNamedArgumentLiteralValue(GrArgumentList argumentList, String label) {
        GrNamedArgument namedArgument = argumentList.findNamedArgument(label);
        if (namedArgument == null) {
            return null;
        }
        if (namedArgument.getExpression() instanceof GrLiteral) {
            return (GrLiteral)namedArgument.getExpression();
        }
        return null;
    }

    private ModuleDependency(Dependencies parent, GrMethodCall methodCall, String configurationName, GrLiteral pathLiteral, GrLiteral configurationLiteral) {
        super(parent, methodCall, configurationName);
        this.myPathLiteral = pathLiteral;
        this.myConfigurationLiteral = configurationLiteral;
    }

    public String getPath() {
        return StringUtil.notNullize((String)PsiElements.getUnquotedText(this.myPathLiteral));
    }

    @Override
    public String getName() {
        List<String> pathSegments = GradleUtil.getPathSegments(this.getPath());
        int segmentCount = pathSegments.size();
        return segmentCount > 0 ? pathSegments.get(segmentCount - 1) : "";
    }

    public String getTargetConfiguration() {
        if (this.myConfigurationLiteral == null) {
            return null;
        }
        return PsiElements.getUnquotedText(this.myConfigurationLiteral);
    }

    public void setName(String newName) {
        this.myNewName = newName;
        this.setModified(true);
    }

    @Override
    protected void apply() {
        this.applyNameChange();
    }

    private void applyNameChange() {
        String newPath;
        if (this.myNewName == null) {
            return;
        }
        List segments = Splitter.on((String)":").splitToList((CharSequence)this.getPath());
        ArrayList modifiableSegments = Lists.newArrayList((Iterable)segments);
        int segmentCount = modifiableSegments.size();
        if (segmentCount == 0) {
            newPath = ":" + this.myNewName.trim();
        } else {
            modifiableSegments.set(segmentCount - 1, this.myNewName);
            newPath = Joiner.on((String)":").join((Iterable)modifiableSegments);
        }
        this.myPathLiteral = PsiElements.setLiteralText(this.myPathLiteral, newPath);
        this.reset();
    }

    @Override
    protected void reset() {
        this.myNewName = null;
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }
}

