/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.dependencies;

import com.android.tools.idea.gradle.dsl.dependencies.Dependency;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.ModuleDependency;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.parser.PsiElements;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SystemProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class Dependencies
extends GradleDslElement {
    private PsiFile myPsiFile;
    private GrClosableBlock myClosureBlock;
    private final List<ExternalDependency> myExternal = Lists.newArrayList();
    private final List<ModuleDependency> myToModules = Lists.newArrayList();
    private final List<ExternalDependency> myExternalToRemove = Lists.newArrayList();
    private final Multimap<String, ExternalDependencySpec> myNewExternal = HashMultimap.create();

    public Dependencies(GradleDslElement parent) {
        super(parent, null, "dependencies");
    }

    @Override
    protected Collection<GradleDslElement> getChildren() {
        return ImmutableList.of();
    }

    @Override
    protected void apply() {
        Dependencies.applyChanges(this.myExternal);
        Dependencies.applyChanges(this.myToModules);
        this.removeExternalDependencies();
        this.applyNewExternalDependencies();
        this.myExternalToRemove.clear();
        this.myNewExternal.clear();
    }

    private static void applyChanges(List<? extends Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            dependency.applyChanges();
        }
    }

    private void removeExternalDependencies() {
        for (ExternalDependency dependency : this.myExternalToRemove) {
            dependency.removeFromParent();
        }
    }

    private void applyNewExternalDependencies() {
        for (Map.Entry entry : this.myNewExternal.entries()) {
            this.applyChanges((String)entry.getKey(), (ExternalDependencySpec)entry.getValue());
        }
    }

    private void applyChanges(String configurationName, ExternalDependencySpec dependency) {
        assert (this.myPsiFile != null);
        String compactNotation = dependency.compactNotation();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)this.myPsiFile.getProject());
        if (this.myClosureBlock == null) {
            String lineSeparator = SystemProperties.getLineSeparator();
            String text = "dependencies {" + lineSeparator + configurationName + " '" + compactNotation + "'" + lineSeparator + "}";
            GrExpression expression = factory.createExpressionFromText((CharSequence)text);
            PsiElement added = this.myPsiFile.add((PsiElement)expression);
            assert (added instanceof GrMethodCallExpression);
            this.parse((GrMethodCallExpression)added);
            CodeStyleManager.getInstance((Project)this.myPsiFile.getProject()).reformat((PsiElement)this.myClosureBlock);
            return;
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)(configurationName + " '" + compactNotation + "'"));
        GrStatement added = this.myClosureBlock.addStatementBefore(statement, null);
        assert (added instanceof GrApplicationStatement);
        List<Dependency> dependencies = Dependency.parse(this, (GrMethodCall)((GrApplicationStatement)added));
        this.add(dependencies);
        CodeStyleManager.getInstance((Project)this.myPsiFile.getProject()).reformat((PsiElement)added);
    }

    public ImmutableList<ExternalDependency> external() {
        return ImmutableList.copyOf(this.myExternal);
    }

    public ImmutableList<ModuleDependency> toModules() {
        return ImmutableList.copyOf(this.myToModules);
    }

    public void add(String configurationName, ExternalDependencySpec dependency) {
        this.myNewExternal.put((Object)configurationName, (Object)dependency);
        this.setModified(true);
    }

    public void remove(ExternalDependency dependency) {
        boolean removed = this.myExternal.remove(dependency);
        if (!removed) {
            String msg = String.format("Dependency '%1$s' cannot be removed because it does not belong to this model", dependency.compactNotation());
            throw new IllegalArgumentException(msg);
        }
        this.myExternalToRemove.add(dependency);
        this.setModified(true);
    }

    public boolean parse(GrMethodCallExpression methodCallExpression) {
        this.myClosureBlock = PsiElements.findClosableBlock(methodCallExpression, "dependencies");
        if (this.myClosureBlock == null) {
            return false;
        }
        GrMethodCall[] methodCalls = (GrMethodCall[])PsiTreeUtil.getChildrenOfType((PsiElement)this.myClosureBlock, GrMethodCall.class);
        if (methodCalls == null) {
            return false;
        }
        for (GrMethodCall methodCall : methodCalls) {
            List<Dependency> dependencies = Dependency.parse(this, methodCall);
            this.add(dependencies);
        }
        return true;
    }

    private void add(List<Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            this.add(dependency);
        }
    }

    private void add(Dependency dependency) {
        if (dependency instanceof ExternalDependency) {
            this.myExternal.add((ExternalDependency)dependency);
        } else if (dependency instanceof ModuleDependency) {
            this.myToModules.add((ModuleDependency)dependency);
        }
    }

    @Override
    protected void reset() {
        Dependencies.reset(this.myExternal);
        Dependencies.reset(this.myToModules);
        this.myExternalToRemove.clear();
        this.myNewExternal.clear();
    }

    private static void reset(List<? extends Dependency> dependencies) {
        for (Dependency dependency : dependencies) {
            dependency.resetState();
        }
    }

    public GrClosableBlock getClosureBlock() {
        return this.myClosureBlock;
    }

    public void setPsiFile(PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }
}

