/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class ArtifactsByConfigurationModuleCustomizer
implements ModuleCustomizer<JavaProject> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void customizeModule(Project project, ModifiableRootModel moduleModel, JavaProject javaProject) {
        Map<String, Set<File>> artifactsByConfiguration;
        if (javaProject != null && (artifactsByConfiguration = javaProject.getArtifactsByConfiguration()) != null) {
            for (Map.Entry<String, Set<File>> entry : artifactsByConfiguration.entrySet()) {
                Set<File> artifacts = entry.getValue();
                if (artifacts == null || artifacts.isEmpty()) continue;
                for (File artifact : artifacts) {
                    if (!artifact.isFile() || !StringUtil.endsWithIgnoreCase((String)artifact.getName(), (String)".jar")) continue;
                    String libraryName = moduleModel.getModule().getName() + "." + FileUtil.getNameWithoutExtension((File)artifact);
                    LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)project);
                    Library library = libraryTable.getLibraryByName(libraryName);
                    if (library != null) continue;
                    LibraryTable.ModifiableModel libraryTableModel = libraryTable.getModifiableModel();
                    try {
                        library = libraryTableModel.createLibrary(libraryName);
                        Library.ModifiableModel libraryModel = library.getModifiableModel();
                        try {
                            String url = AbstractDependenciesModuleCustomizer.pathToUrl(artifact.getPath());
                            libraryModel.addRoot(url, OrderRootType.CLASSES);
                        }
                        finally {
                            libraryModel.commit();
                        }
                    }
                    finally {
                        libraryTableModel.commit();
                    }
                    LibraryOrderEntry orderEntry = moduleModel.addLibraryEntry(library);
                    orderEntry.setScope(DependencyScope.COMPILE);
                    orderEntry.setExported(true);
                }
            }
        }
    }
}

