/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;

public class MakeGradleModuleAction
extends AndroidStudioGradleAction {
    public MakeGradleModuleAction() {
        super("Make Module(s)");
    }

    @Override
    protected void doUpdate(AnActionEvent e, Project project) {
        MakeGradleModuleAction.updatePresentation(e, project);
    }

    public static void updatePresentation(AnActionEvent e, Project project) {
        String presentationText;
        DataContext dataContext = e.getDataContext();
        Module[] modules = Projects.getModulesToBuildFromSelection(project, dataContext);
        int moduleCount = modules.length;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(moduleCount > 0);
        if (moduleCount > 0) {
            String text = "Make Module";
            if (moduleCount > 1) {
                text = text + "s";
            }
            for (int i = 0; i < moduleCount; ++i) {
                if (text.length() > 30) {
                    text = "Make Selected Modules";
                    break;
                }
                Module toMake = modules[i];
                if (i != 0) {
                    text = text + ",";
                }
                text = text + " '" + toMake.getName() + "'";
            }
            presentationText = text;
        } else {
            presentationText = "Make";
        }
        presentation.setText(presentationText);
        presentation.setVisible(moduleCount > 0 || !"ProjectViewPopup".equals(e.getPlace()));
    }

    @Override
    protected void doPerform(AnActionEvent e, Project project) {
        Module[] modules = Projects.getModulesToBuildFromSelection(project, e.getDataContext());
        GradleInvoker.getInstance(project).compileJava(modules, GradleInvoker.TestCompileType.NONE);
    }
}

