/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleContentRoot;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class JavaProject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String myModuleName;
    private Collection<JavaModuleContentRoot> myContentRoots = Lists.newArrayList();
    private Collection<JavaModuleDependency> myJavaModuleDependencies = Lists.newArrayList();
    private Collection<JarLibraryDependency> myJarLibraryDependencies = Lists.newArrayList();
    private Map<String, Set<File>> myArtifactsByConfiguration;
    private ExtIdeaCompilerOutput myCompilerOutput;
    private File myBuildFolderPath;
    private String myLanguageLevel;
    private boolean myBuildable;
    private boolean myAndroidProjectWithoutVariants;

    public static JavaProject create(IdeaModule ideaModule, ModuleExtendedModel extendedModel, boolean androidProjectWithoutVariants) {
        Collection<? extends IdeaContentRoot> contentRoots = JavaProject.getContentRoots(ideaModule, extendedModel);
        Map artifactsByConfiguration = Maps.newHashMap();
        if (extendedModel != null) {
            artifactsByConfiguration = extendedModel.getArtifactsByConfiguration();
        }
        ExtIdeaCompilerOutput compilerOutput = extendedModel != null ? extendedModel.getCompilerOutput() : null;
        File buildFolderPath = ideaModule.getGradleProject().getBuildDirectory();
        boolean buildable = !androidProjectWithoutVariants && JavaProject.isBuildable(ideaModule);
        String languageLevel = null;
        if (extendedModel != null) {
            languageLevel = extendedModel.getJavaSourceCompatibility();
        }
        return new JavaProject(ideaModule.getName(), contentRoots, JavaProject.getDependencies(ideaModule), artifactsByConfiguration, compilerOutput, buildFolderPath, languageLevel, buildable, androidProjectWithoutVariants);
    }

    private static Collection<? extends IdeaContentRoot> getContentRoots(IdeaModule ideaModule, ModuleExtendedModel extendedModel) {
        DomainObjectSet contentRoots;
        DomainObjectSet domainObjectSet = contentRoots = extendedModel != null ? extendedModel.getContentRoots() : null;
        if (contentRoots != null) {
            return contentRoots;
        }
        contentRoots = ideaModule.getContentRoots();
        if (contentRoots != null) {
            return contentRoots;
        }
        return Collections.emptyList();
    }

    private static List<? extends IdeaDependency> getDependencies(IdeaModule ideaModule) {
        List dependencies = ideaModule.getDependencies().getAll();
        if (dependencies != null) {
            return dependencies;
        }
        return Collections.emptyList();
    }

    private static boolean isBuildable(IdeaModule ideaModule) {
        for (GradleTask task : ideaModule.getGradleProject().getTasks()) {
            if (!"compileJava".equals(task.getName())) continue;
            return true;
        }
        return false;
    }

    public JavaProject(String name, Collection<? extends IdeaContentRoot> contentRoots, List<? extends IdeaDependency> dependencies, Map<String, Set<File>> artifactsByConfiguration, ExtIdeaCompilerOutput compilerOutput, File buildFolderPath, String languageLevel, boolean buildable, boolean androidProjectWithoutVariants) {
        this.myModuleName = name;
        for (IdeaContentRoot ideaContentRoot : contentRoots) {
            if (ideaContentRoot == null) continue;
            this.myContentRoots.add(JavaModuleContentRoot.copy(ideaContentRoot));
        }
        for (IdeaDependency ideaDependency : dependencies) {
            JavaModuleDependency moduleDependency;
            if (ideaDependency instanceof IdeaSingleEntryLibraryDependency) {
                JarLibraryDependency libraryDependency = JarLibraryDependency.copy((IdeaSingleEntryLibraryDependency)ideaDependency);
                if (libraryDependency == null) continue;
                this.myJarLibraryDependencies.add(libraryDependency);
                continue;
            }
            if (!(ideaDependency instanceof IdeaModuleDependency) || (moduleDependency = JavaModuleDependency.copy((IdeaModuleDependency)ideaDependency)) == null) continue;
            this.myJavaModuleDependencies.add(moduleDependency);
        }
        this.myArtifactsByConfiguration = artifactsByConfiguration;
        this.myCompilerOutput = compilerOutput;
        this.myBuildFolderPath = buildFolderPath;
        this.myLanguageLevel = languageLevel;
        this.myBuildable = buildable;
        this.myAndroidProjectWithoutVariants = androidProjectWithoutVariants;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public Collection<JavaModuleContentRoot> getContentRoots() {
        return this.myContentRoots;
    }

    public boolean containsSourceFile(File file) {
        for (JavaModuleContentRoot contentRoot : this.getContentRoots()) {
            if (contentRoot == null || !JavaProject.containsFile(contentRoot, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFile(JavaModuleContentRoot contentRoot, File file) {
        return JavaProject.containsFile(contentRoot.getSourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getTestDirPaths(), file) || JavaProject.containsFile(contentRoot.getResourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getGenSourceDirPaths(), file) || JavaProject.containsFile(contentRoot.getGenTestDirPaths(), file) || JavaProject.containsFile(contentRoot.getTestResourceDirPaths(), file);
    }

    private static boolean containsFile(Collection<File> folderPaths, File file) {
        if (folderPaths != null) {
            for (File path : folderPaths) {
                if (!FileUtil.isAncestor((File)path, (File)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public File getJarFilePath() {
        Set<File> defaultArtifacts;
        Map<String, Set<File>> artifactsByConfiguration = this.getArtifactsByConfiguration();
        if (artifactsByConfiguration != null && !(defaultArtifacts = artifactsByConfiguration.get("default")).isEmpty()) {
            return (File)ContainerUtil.getFirstItem(defaultArtifacts);
        }
        return null;
    }

    public Map<String, Set<File>> getArtifactsByConfiguration() {
        return this.myArtifactsByConfiguration;
    }

    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }

    public Collection<JavaModuleDependency> getJavaModuleDependencies() {
        return this.myJavaModuleDependencies;
    }

    public Collection<JarLibraryDependency> getJarLibraryDependencies() {
        return this.myJarLibraryDependencies;
    }

    public boolean isBuildable() {
        return this.myBuildable;
    }

    public boolean isAndroidProjectWithoutVariants() {
        return this.myAndroidProjectWithoutVariants;
    }

    public LanguageLevel getJavaLanguageLevel() {
        if (this.myLanguageLevel != null) {
            return LanguageLevel.parse((String)this.myLanguageLevel);
        }
        return null;
    }
}

