/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace.treemodel;

import com.android.tools.idea.editors.vmtrace.treemodel.NullStatsNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsByThreadNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsTableColumn;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class VmStatsTreeTableModel
extends AbstractTreeTableModel
implements TreeTableModel {
    private VmTraceData myVmTraceData;
    private StatsNode myRootNode;
    private ThreadInfo myThread;
    private ClockType myClockType = ClockType.GLOBAL;
    private StatsTableColumn mySortByColumn = StatsTableColumn.EXCLUSIVE_TIME;
    private boolean mySortAscending = true;

    public VmStatsTreeTableModel() {
        this.myRootNode = new NullStatsNode();
    }

    public void setTraceData(VmTraceData traceData, ThreadInfo thread) {
        this.myVmTraceData = traceData;
        this.setThread(thread);
    }

    public void setClockType(ClockType type) {
        this.myClockType = type;
        this.fireTreeStructureChanged();
    }

    public void setThread(ThreadInfo thread) {
        this.myThread = thread;
        this.myRootNode = this.myVmTraceData != null ? new StatsByThreadNode(this.myVmTraceData, thread) : new NullStatsNode();
        this.fireTreeStructureChanged();
    }

    private void fireTreeStructureChanged() {
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this.myRootNode});
        for (TreeModelListener listener : this.getTreeModelListeners()) {
            listener.treeStructureChanged(e);
        }
    }

    public int getColumnCount() {
        return StatsTableColumn.values().length;
    }

    public String getColumnName(int column) {
        return this.getStatsTableColumn(column).toString();
    }

    private StatsTableColumn getStatsTableColumn(int index) {
        return StatsTableColumn.fromColumnIndex(index);
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        if (!(node instanceof StatsNode)) {
            return "???";
        }
        return ((StatsNode)node).getValueAt(column, this.myThread, this.myVmTraceData, this.myClockType);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRootNode;
    }

    public Object getChild(Object parent, int index) {
        return ((StatsNode)parent).getChild(index);
    }

    public int getChildCount(Object parent) {
        return ((StatsNode)parent).getChildCount();
    }

    public boolean isLeaf(Object node) {
        return ((StatsNode)node).isLeaf();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    public void sortByColumn(StatsTableColumn column) {
        if (column != this.mySortByColumn) {
            this.mySortByColumn = column;
            this.mySortAscending = true;
        } else {
            this.mySortAscending = !this.mySortAscending;
        }
        this.myRootNode.setSortColumn(this.mySortByColumn, this.mySortAscending);
        this.fireTreeStructureChanged();
    }
}

