/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.ui;

import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ui.VariantsComboBox;
import com.android.tools.swing.ui.SwatchComponent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;

public class ResourceComponent
extends JPanel {
    public static final String NAME_LABEL = "Name Label";
    private final SwatchComponent mySwatchComponent = new SwatchComponent();
    private final JLabel myNameLabel = new JLabel();
    protected final JLabel myWarningLabel = new JLabel();
    private final VariantsComboBox myVariantCombo = new VariantsComboBox();

    public ResourceComponent() {
        super(new BorderLayout(0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP));
        this.setBorder(BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0, ThemeEditorConstants.ATTRIBUTE_MARGIN / 2, 0));
        this.myWarningLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWarningLabel.setVisible(false);
        this.myNameLabel.setName(NAME_LABEL);
        this.myNameLabel.setForeground((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR);
        Box topRowPanel = new Box(2);
        topRowPanel.add(this.myNameLabel);
        topRowPanel.add(this.myWarningLabel);
        topRowPanel.add(Box.createHorizontalGlue());
        topRowPanel.add(this.myVariantCombo);
        this.add((Component)topRowPanel, "Center");
        this.add((Component)this.mySwatchComponent, "South");
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int firstRowHeight = Math.max(this.getFontMetrics(this.getFont()).getHeight(), this.myVariantCombo.getPreferredSize().height);
            int secondRowHeight = this.mySwatchComponent.getPreferredSize().height;
            return new Dimension(0, ThemeEditorConstants.ATTRIBUTE_MARGIN + ThemeEditorConstants.ATTRIBUTE_ROW_GAP + firstRowHeight + secondRowHeight);
        }
        return super.getPreferredSize();
    }

    public void setSwatchIcon(SwatchComponent.SwatchIcon icon) {
        this.mySwatchComponent.setSwatchIcon(icon);
    }

    public void showStack(boolean show) {
        this.mySwatchComponent.showStack(show);
    }

    public void setNameText(String name) {
        this.myNameLabel.setText(name);
    }

    public void setWarning(String warning) {
        if (!StringUtil.isEmpty((String)warning)) {
            this.myWarningLabel.setToolTipText(warning);
            this.myWarningLabel.setVisible(true);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    public void setVariantsModel(ComboBoxModel comboBoxModel) {
        this.myVariantCombo.setModel(comboBoxModel != null ? comboBoxModel : new DefaultComboBoxModel());
    }

    public void addVariantItemListener(ItemListener itemListener) {
        this.myVariantCombo.addItemListener(itemListener);
    }

    public void addVariantPopupClosingListener(VariantsComboBox.PopupClosingListener listener) {
        this.myVariantCombo.addPopupClosingListener(listener);
    }

    public void setValueText(String value) {
        this.mySwatchComponent.setText(value);
    }

    public String getValueText() {
        return this.mySwatchComponent.getText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.mySwatchComponent != null) {
            this.mySwatchComponent.setFont(font);
        }
        if (this.myNameLabel != null) {
            this.myNameLabel.setFont(font);
        }
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        this.myNameLabel.setComponentPopupMenu(popup);
        this.myWarningLabel.setComponentPopupMenu(popup);
        this.mySwatchComponent.setComponentPopupMenu(popup);
    }

    public void addSwatchListener(ActionListener listener) {
        this.mySwatchComponent.addSwatchListener(listener);
    }

    public void addTextListener(ActionListener listener) {
        this.mySwatchComponent.addTextListener(listener);
    }

    public void addTextDocumentListener(DocumentListener listener) {
        this.mySwatchComponent.addTextDocumentListener(listener);
    }

    public boolean hasWarningIcon() {
        return this.mySwatchComponent.hasWarningIcon();
    }

    public void setVariantComboVisible(boolean isVisible) {
        this.myVariantCombo.setVisible(isVisible);
    }

    public ValidationInfo createSwatchValidationInfo(String errorText) {
        return new ValidationInfo(errorText, (JComponent)this.mySwatchComponent);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.myWarningLabel.isVisible()) {
            this.validate();
            if (SwingUtilities.getLocalBounds(this.myWarningLabel).contains(SwingUtilities.convertMouseEvent(this, event, this.myWarningLabel).getPoint())) {
                return this.myWarningLabel.getToolTipText();
            }
        }
        return super.getToolTipText(event);
    }

    public Dimension getSwatchIconSize() {
        return new Dimension(this.mySwatchComponent.getHeight(), this.mySwatchComponent.getHeight());
    }
}

