/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.Html;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JTable;
import org.jetbrains.android.dom.attrs.AttributeDefinition;

public class FlagRendererEditor
extends TypedCellRendererEditor<EditedStyleItem, String> {
    private final Box myBox = new Box(2);
    private final JLabel myLabel = new JLabel(){

        @Override
        public boolean isShowing() {
            return true;
        }
    };
    private final EditorTextField myTextField = new EditorTextField();
    private EditedStyleItem myItem = null;

    public FlagRendererEditor() {
        this.myBox.add((Component)this.myTextField);
        this.myBox.add(Box.createHorizontalGlue());
        JButton editButton = new JButton();
        this.myBox.add(editButton);
        this.myTextField.setAlignmentX(0.0f);
        this.myTextField.setOneLineMode(true);
        editButton.setAlignmentX(1.0f);
        editButton.setText("...");
        int buttonWidth = editButton.getFontMetrics(editButton.getFont()).stringWidth("...") + 10;
        editButton.setPreferredSize(new Dimension(buttonWidth, editButton.getHeight()));
        this.myLabel.setOpaque(true);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlagDialog dialog = new FlagDialog();
                dialog.show();
                if (dialog.isOK()) {
                    FlagRendererEditor.this.myTextField.setText(dialog.getValue());
                    FlagRendererEditor.this.stopCellEditing();
                } else {
                    FlagRendererEditor.this.cancelCellEditing();
                }
            }
        });
    }

    @Override
    public Component getRendererComponent(JTable table, EditedStyleItem value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component;
        this.myItem = value;
        if (column == 0) {
            component = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, ThemeEditorUtils.getDisplayHtml(this.myItem), isSelected, hasFocus, row, column);
        } else {
            this.myLabel.setText(this.myItem.getValue());
            component = this.myLabel;
        }
        return component;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myItem = value;
        this.myTextField.setText(this.myItem.getValue());
        return this.myBox;
    }

    @Override
    public String getEditorValue() {
        return this.myTextField.getText();
    }

    private class FlagDialog
    extends DialogWrapper {
        private final HashSet<String> mySelectedFlags;

        public FlagDialog() {
            super(false);
            this.mySelectedFlags = new HashSet();
            String value = FlagRendererEditor.this.myItem.getValue();
            if (!StringUtil.isEmpty((String)value)) {
                for (String flag : Splitter.on((String)"|").split((CharSequence)value)) {
                    this.mySelectedFlags.add(flag);
                }
            }
            this.setTitle("Flag Options");
            this.init();
        }

        protected JComponent createCenterPanel() {
            Box box = new Box(3);
            AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(FlagRendererEditor.this.myItem.getSourceStyle().getConfiguration(), FlagRendererEditor.this.myItem.getSelectedValue());
            if (attrDefinition != null) {
                String[] flagNames;
                for (String flagName : flagNames = attrDefinition.getValues()) {
                    FlagCheckBox flag = new FlagCheckBox(flagName, attrDefinition.getValueDoc(flagName));
                    if (this.mySelectedFlags.contains(flagName)) {
                        flag.setSelected(true);
                    }
                    box.add(flag);
                }
            }
            return box;
        }

        public String getValue() {
            return Joiner.on((String)"|").join(this.mySelectedFlags);
        }

        private class FlagCheckBox
        extends JCheckBox {
            LightweightHint myTooltipHint;
            final String myToolTipText;

            public FlagCheckBox(String name, String toolTipText) {
                super(name);
                this.myToolTipText = toolTipText;
                this.addActionListener(new CheckBoxListener());
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        FlagCheckBox.this.showTooltip(e);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (FlagCheckBox.this.myTooltipHint != null) {
                            FlagCheckBox.this.myTooltipHint.hide();
                            FlagCheckBox.this.myTooltipHint = null;
                        }
                    }
                });
            }

            public void showTooltip(MouseEvent e) {
                if (this.myToolTipText == null) {
                    return;
                }
                Point point = e.getPoint();
                if (this.myTooltipHint == null) {
                    HintHint hintHint = new HintHint((Component)this, point).setAwtTooltip(true).setContentActive(false);
                    JLayeredPane layeredPane = this.getRootPane().getLayeredPane();
                    JEditorPane pane = IdeTooltipManager.initPane((Html)new Html(this.myToolTipText.replaceAll("\\s+", " ")), (HintHint)hintHint, (JLayeredPane)layeredPane);
                    this.myTooltipHint = new LightweightHint((JComponent)pane);
                    this.myTooltipHint.show((JComponent)this, point.x, point.y, null, hintHint);
                } else {
                    this.myTooltipHint.setLocation(new RelativePoint((Component)this, point));
                }
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent e) {
                super.processMouseMotionEvent(e);
                if (this.myTooltipHint != null && !this.myTooltipHint.isRealPopup()) {
                    this.showTooltip(e);
                }
            }
        }

        private class CheckBoxListener
        implements ActionListener {
            private CheckBoxListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox checkbox = (JCheckBox)e.getSource();
                String name = checkbox.getText();
                if (FlagDialog.this.mySelectedFlags.contains(name)) {
                    FlagDialog.this.mySelectedFlags.remove(name);
                } else {
                    FlagDialog.this.mySelectedFlags.add(name);
                }
            }
        }
    }
}

