/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.swing.ui.SwatchComponent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;

public class ColorRendererEditor
extends GraphicalResourceRendererEditor {
    public ColorRendererEditor(ThemeEditorContext context, AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        super(context, previewPanel, isEditor);
    }

    @Override
    protected void updateComponent(ThemeEditorContext context, ResourceComponent component, EditedStyleItem item) {
        ResourceResolver resourceResolver = context.getResourceResolver();
        assert (resourceResolver != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, (ResourceValue)item.getSelectedValue(), context.getProject());
        if (colors.isEmpty()) {
            component.setSwatchIcon(SwatchComponent.WARNING_ICON);
        } else {
            component.setSwatchIcon(new SwatchComponent.ColorIcon((Color)Iterables.getLast(colors)));
        }
        component.showStack(colors.size() > 1);
        component.setNameText(item.getQualifiedName());
        component.setValueText(item.getValue());
        if (!colors.isEmpty()) {
            Color color = (Color)Iterables.getLast(colors);
            String attributeName = item.getName();
            ImmutableMap<String, Color> contrastColorsWithDescription = ColorUtils.getContrastColorsWithDescription(context, attributeName);
            component.setWarning(ColorUtils.getContrastWarningMessage(contrastColorsWithDescription, color, ColorUtils.isBackgroundAttribute(attributeName)));
        } else {
            component.setWarning(null);
        }
    }

    @Override
    protected ResourceType[] getAllowedResourceTypes() {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(this.myContext.getConfiguration(), this.myItem.getSelectedValue());
        String attributeName = this.myItem.getName().toLowerCase();
        if (attributeName.contains("color") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            return COLORS_ONLY;
        }
        if (attributeName.contains("drawable") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            return DRAWABLES_ONLY;
        }
        return COLORS_AND_DRAWABLES;
    }
}

