/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.TypedCellRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.intellij.openapi.ui.ComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import org.jetbrains.android.uipreview.ChooseResourceDialog;

public class BooleanRendererEditor
extends TypedCellRendererEditor<EditedStyleItem, String> {
    private static final String USE_REFERENCE = "Use reference ...";
    private static final ResourceType[] BOOLEAN_TYPE = new ResourceType[]{ResourceType.BOOL};
    private static final String[] COMBOBOX_OPTIONS = new String[]{"true", "false", "Use reference ..."};
    private final ComboBox myComboBox;
    private final ThemeEditorContext myContext;
    private String myResultValue;
    private String myEditedItemValue;

    public BooleanRendererEditor(ThemeEditorContext context) {
        this.myContext = context;
        this.myComboBox = new ComboBox(){

            public boolean isShowing() {
                return true;
            }
        };
        this.myComboBox.addActionListener((ActionListener)new BooleanChoiceListener());
    }

    @Override
    public Component getRendererComponent(JTable table, EditedStyleItem value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object component;
        if (column == 0) {
            component = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, ThemeEditorUtils.getDisplayHtml(value), isSelected, hasFocus, row, column);
        } else {
            this.myComboBox.removeAllItems();
            this.myComboBox.addItem((Object)value.getValue());
            component = this.myComboBox;
        }
        return component;
    }

    @Override
    public Component getEditorComponent(JTable table, EditedStyleItem value, boolean isSelected, int row, int column) {
        this.myEditedItemValue = value.getValue();
        DefaultComboBoxModel<String> comboBoxModel = new DefaultComboBoxModel<String>(COMBOBOX_OPTIONS);
        if (!this.myEditedItemValue.equals("true") && !this.myEditedItemValue.equals("false")) {
            comboBoxModel.insertElementAt(this.myEditedItemValue, 0);
        }
        this.myComboBox.setModel(comboBoxModel);
        this.myComboBox.setSelectedItem((Object)this.myEditedItemValue);
        return this.myComboBox;
    }

    @Override
    public String getEditorValue() {
        return this.myResultValue;
    }

    private class BooleanChoiceListener
    implements ActionListener {
        private BooleanChoiceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedValue = (String)BooleanRendererEditor.this.myComboBox.getSelectedItem();
            if (BooleanRendererEditor.USE_REFERENCE.equals(selectedValue)) {
                BooleanRendererEditor.this.myComboBox.hidePopup();
                ChooseResourceDialog dialog = new ChooseResourceDialog(BooleanRendererEditor.this.myContext.getModuleForResources(), BOOLEAN_TYPE, BooleanRendererEditor.this.myEditedItemValue, null);
                dialog.show();
                if (dialog.isOK()) {
                    BooleanRendererEditor.this.myResultValue = dialog.getResourceName();
                    BooleanRendererEditor.this.stopCellEditing();
                } else {
                    BooleanRendererEditor.this.myResultValue = null;
                    BooleanRendererEditor.this.cancelCellEditing();
                }
            } else {
                BooleanRendererEditor.this.myResultValue = selectedValue;
                BooleanRendererEditor.this.stopCellEditing();
            }
        }
    }
}

