/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ColorPalette;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AttributesModelColorPaletteModel
implements ColorPalette.ColorPaletteModel,
TableModelListener {
    private final ResourceResolver myResourceResolver;
    private final AttributesTableModel myModel;
    private final Project myProject;
    private List<Color> myColorList;
    private final Multimap<Color, EditedStyleItem> myColorReferences = HashMultimap.create();

    public AttributesModelColorPaletteModel(Configuration configuration, AttributesTableModel model) {
        this.myResourceResolver = configuration.getResourceResolver();
        this.myProject = configuration.getModule().getProject();
        this.myModel = model;
        this.myModel.addTableModelListener(this);
        this.loadColors();
    }

    @Override
    public int getCount() {
        return this.myColorList.size();
    }

    @Override
    public Color getColorAt(int i) {
        return this.myColorList.get(i);
    }

    @Override
    public int indexOf(Color c) {
        return this.myColorList.indexOf(c);
    }

    @Override
    public String getToolTipAt(int i) {
        StringBuilder tooltip = new StringBuilder("This color is used in:\n\n");
        for (EditedStyleItem item : this.myColorReferences.get((Object)this.myColorList.get(i))) {
            tooltip.append(item.getName()).append('\n');
        }
        return tooltip.toString();
    }

    private void loadColors() {
        if (this.myResourceResolver == null) {
            this.myColorList = Collections.emptyList();
            return;
        }
        int rows = this.myModel.getRowCount();
        HashMultiset colorSet = HashMultiset.create();
        for (int i = 0; i < rows; ++i) {
            if (this.myModel.getCellClass(i, 0) != Color.class) continue;
            EditedStyleItem item = (EditedStyleItem)this.myModel.getValueAt(i, 0);
            for (Color color : ResourceHelper.resolveMultipleColors((RenderResources)this.myResourceResolver, (ResourceValue)item.getSelectedValue(), this.myProject)) {
                this.myColorReferences.put((Object)color, (Object)item);
                colorSet.add((Object)color);
            }
        }
        this.myColorList = ImmutableList.copyOf((Collection)Multisets.copyHighestCountFirst((Multiset)colorSet).elementSet());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.loadColors();
    }

    public List<EditedStyleItem> getReferences(Color color) {
        return ImmutableList.copyOf((Collection)this.myColorReferences.get((Object)color));
    }
}

