/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jdom.Element;

public class ThemeEditorProvider
implements FileEditorProvider,
DumbAware {
    public static final boolean THEME_EDITOR_ENABLE = true;
    private static final String THEME_NAME = "theme-name";
    private static final String STYLE_NAME = "style-name";
    private static final String MODULE_NAME = "module-name";
    private static final String PROPORTION = "proportion";

    public boolean accept(Project project, VirtualFile file) {
        return file instanceof ThemeEditorVirtualFile;
    }

    public FileEditor createEditor(Project project, VirtualFile file) {
        UsageTracker.getInstance().trackEvent("themeEditor", "themeEditorOpened", null, null);
        return new ThemeEditor(project, file);
    }

    public void disposeEditor(FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    public FileEditorState readState(Element sourceElement, Project project, VirtualFile file) {
        String themeName = sourceElement.getAttributeValue(THEME_NAME);
        String styleName = sourceElement.getAttributeValue(STYLE_NAME);
        String moduleName = sourceElement.getAttributeValue(MODULE_NAME);
        Float proportion = null;
        try {
            String proportionString = sourceElement.getAttributeValue(PROPORTION);
            if (proportionString != null) {
                proportion = Float.valueOf(Float.parseFloat(proportionString));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new ThemeEditorState(themeName, styleName, proportion, moduleName);
    }

    public void writeState(FileEditorState state, Project project, Element targetElement) {
        if (!(state instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState editorState = (ThemeEditorState)state;
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, THEME_NAME, editorState.getThemeName());
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, STYLE_NAME, editorState.getSubStyleName());
        ThemeEditorProvider.setAttributeIfNotNull(targetElement, MODULE_NAME, editorState.getModuleName());
        targetElement.setAttribute(PROPORTION, Float.toString(editorState.getProportion()));
    }

    private static void setAttributeIfNotNull(Element targetElement, String paramName, String paramValue) {
        if (paramValue != null) {
            targetElement.setAttribute(paramName, paramValue);
        }
    }

    public String getEditorTypeId() {
        return "themeEditor";
    }

    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
    }

    public static boolean isAndroidTheme(PsiFile file) {
        if (ResourceHelper.getFolderType(file) != ResourceFolderType.VALUES || !(file instanceof XmlFile)) {
            return false;
        }
        String name = file.getName();
        if (name.equals("strings.xml")) {
            return false;
        }
        if (name.equals("styles.xml")) {
            return true;
        }
        XmlTag rootTag = ((XmlFile)file).getRootTag();
        if (rootTag == null || !rootTag.getName().equals("resources")) {
            return false;
        }
        for (XmlTag child : rootTag.getSubTags()) {
            if (!child.getName().equals("style")) continue;
            return true;
        }
        return false;
    }
}

