/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ThemeEditorComponent;
import com.android.tools.idea.editors.theme.ThemeEditorState;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class ThemeEditor
extends UserDataHolderBase
implements FileEditor {
    private final ThemeEditorVirtualFile myVirtualFile;
    private final ThemeEditorComponent myComponent;

    public ThemeEditor(Project project, VirtualFile file) {
        this.myVirtualFile = (ThemeEditorVirtualFile)file;
        this.myComponent = new ThemeEditorComponent(project);
        Disposer.register((Disposable)this, (Disposable)this.myComponent);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorStyle theme = null;
                        ThemeEditorStyle subStyle = null;
                        if (!ThemeEditor.this.myComponent.getSelectedModule().isDisposed()) {
                            if (ModuleRootManager.getInstance((Module)ThemeEditor.this.myComponent.getSelectedModule()).getSdk() == null) {
                                return;
                            }
                            theme = ThemeEditor.this.myComponent.getSelectedTheme();
                            subStyle = ThemeEditor.this.myComponent.getCurrentSubStyle();
                        }
                        ThemeEditor.this.myComponent.reload(theme == null ? null : theme.getQualifiedName(), subStyle == null ? null : subStyle.getQualifiedName());
                    }
                });
            }
        });
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "Theme Editor";
    }

    public FileEditorState getState(FileEditorStateLevel fileEditorStateLevel) {
        ThemeEditorStyle theme = this.myComponent.getSelectedTheme();
        ThemeEditorStyle subStyle = this.myComponent.getCurrentSubStyle();
        return new ThemeEditorState(theme == null ? null : theme.getQualifiedName(), subStyle == null ? null : subStyle.getQualifiedName(), Float.valueOf(this.myComponent.getProportion()), this.myComponent.getSelectedModule().getName());
    }

    public void setState(FileEditorState fileEditorState) {
        if (!(fileEditorState instanceof ThemeEditorState)) {
            return;
        }
        ThemeEditorState state = (ThemeEditorState)fileEditorState;
        this.myComponent.reload(state.getThemeName(), state.getSubStyleName(), state.getModuleName());
        this.myComponent.setProportion(state.getProportion());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myVirtualFile.isValid();
    }

    public void selectNotify() {
        this.myComponent.selectNotify();
    }

    public void deselectNotify() {
        this.myComponent.deselectNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public ThemeEditorVirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public void dispose() {
    }
}

