/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.XmlTagUtils;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.Locale;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;

public class StringsWriteUtils {
    public static boolean setAttributeForItems(Project project, final String attribute, final String value, List<ResourceItem> items) {
        if (items.isEmpty()) {
            return false;
        }
        final ArrayList tags = Lists.newArrayListWithExpectedSize((int)items.size());
        HashSet files = Sets.newHashSetWithExpectedSize((int)items.size());
        for (ResourceItem item : items) {
            XmlTag tag = StringResourceData.resourceToXmlTag(item);
            if (tag == null) {
                return false;
            }
            tags.add(tag);
            files.add(tag.getContainingFile());
        }
        final boolean deleteTag = attribute.equals("name") && (value == null || value.isEmpty());
        new WriteCommandAction.Simple(project, "Setting attribute " + attribute, files.toArray(new PsiFile[files.size()])){

            public void run() {
                for (XmlTag tag : tags) {
                    if (deleteTag) {
                        tag.delete();
                        continue;
                    }
                    tag.setAttribute(attribute, value);
                }
            }
        }.execute();
        return true;
    }

    public static boolean setItemText(final Project project, ResourceItem item, final String value) {
        if (value.isEmpty()) {
            return StringsWriteUtils.setAttributeForItems(project, "name", null, Collections.singletonList(item));
        }
        final XmlTag tag = StringResourceData.resourceToXmlTag(item);
        if (tag != null) {
            new WriteCommandAction.Simple(project, "Setting value of " + item.getName(), new PsiFile[]{tag.getContainingFile()}){

                public void run() {
                    for (XmlTagChild child : tag.getValue().getChildren()) {
                        child.delete();
                    }
                    XmlTag text = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<a>" + value + "</a>"));
                    XmlTagUtils.escape(text);
                    for (XmlTagChild psiElement : text.getValue().getChildren()) {
                        tag.add((PsiElement)psiElement);
                    }
                }
            }.execute();
            return true;
        }
        return false;
    }

    public static ResourceItem createItem(final AndroidFacet facet, VirtualFile resFolder, final Locale locale, final String name, final String value, final boolean translatable) {
        Project project = facet.getModule().getProject();
        XmlFile resourceFile = StringsWriteUtils.getStringResourceFile(project, resFolder, locale);
        if (resourceFile == null) {
            return null;
        }
        final XmlTag root = resourceFile.getRootTag();
        if (root == null) {
            return null;
        }
        new WriteCommandAction.Simple(project, "Creating string " + name, new PsiFile[]{resourceFile}){

            public void run() {
                XmlTag child = root.createChildTag(ResourceType.STRING.getName(), root.getNamespace(), value, false);
                child.setAttribute("name", name);
                child.setAttribute("translatable", translatable ? null : "false");
                XmlTagUtils.escape(child);
                root.addSubTag(child, false);
            }
        }.execute();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return StringsWriteUtils.getStringResourceItem(facet, name, locale);
        }
        return (ResourceItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<ResourceItem>(){

            public ResourceItem compute() {
                return StringsWriteUtils.getStringResourceItem(facet, name, locale);
            }
        });
    }

    private static ResourceItem getStringResourceItem(AndroidFacet facet, String key, Locale locale) {
        LocalResourceRepository repository = facet.getModuleResources(true);
        repository.sync();
        List items = repository.getResourceItem(ResourceType.STRING, key);
        if (items == null) {
            return null;
        }
        for (ResourceItem item : items) {
            Locale l;
            LocaleQualifier qualifier;
            FolderConfiguration config = item.getConfiguration();
            LocaleQualifier localeQualifier = qualifier = config == null ? null : config.getLocaleQualifier();
            if (!(qualifier == null ? locale == null : (l = Locale.create(qualifier)).equals(locale))) continue;
            return item;
        }
        return null;
    }

    private static XmlFile getStringResourceFile(Project project, final VirtualFile resFolder, Locale locale) {
        XmlFile resourceFile;
        FolderConfiguration configuration = new FolderConfiguration();
        if (locale != null) {
            configuration.setLocaleQualifier(locale.qualifier);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        final String valuesFolderName = configuration.getFolderName(ResourceFolderType.VALUES);
        VirtualFile valuesFolder = resFolder.findChild(valuesFolderName);
        if (valuesFolder == null && (valuesFolder = (VirtualFile)new WriteCommandAction<VirtualFile>(project, "Creating directory " + valuesFolderName, new PsiFile[]{manager.findFile(resFolder)}){

            public void run(Result<VirtualFile> result) {
                try {
                    result.setResult((Object)resFolder.createChildDirectory((Object)this, valuesFolderName));
                }
                catch (IOException ex) {
                    result.setResult(null);
                }
            }
        }.execute().getResultObject()) == null) {
            return null;
        }
        String resourceFileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STRING);
        if (resourceFileName == null) {
            return null;
        }
        VirtualFile resourceVirtualFile = valuesFolder.findChild(resourceFileName);
        if (resourceVirtualFile == null) {
            PsiDirectory valuesDir = manager.findDirectory(valuesFolder);
            if (valuesDir == null) {
                return null;
            }
            try {
                resourceFile = AndroidResourceUtil.createFileResource(resourceFileName, valuesDir, "", ResourceType.STRING.getName(), true);
            }
            catch (Exception ex) {
                return null;
            }
        } else {
            PsiFile resourcePsiFile = manager.findFile(resourceVirtualFile);
            if (!(resourcePsiFile instanceof XmlFile)) {
                return null;
            }
            resourceFile = (XmlFile)resourcePsiFile;
        }
        return resourceFile;
    }
}

