/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;

public class SelectionModel
implements Disposable {
    private final EventDispatcher<SelectionListener> myDispatcher = EventDispatcher.create(SelectionListener.class);
    private Heap myHeap;
    private ClassObj myClassObj;
    private Instance myInstance;
    private boolean mySelectionLocked;

    public SelectionModel(Heap heap) {
        this.myHeap = heap;
    }

    public void dispose() {
        this.myHeap = null;
        this.myClassObj = null;
        this.myInstance = null;
    }

    public Heap getHeap() {
        return this.myHeap;
    }

    public void setHeap(Heap heap) {
        if (this.myHeap != heap && !this.mySelectionLocked) {
            this.myHeap = heap;
            ((SelectionListener)this.myDispatcher.getMulticaster()).onHeapChanged(this.myHeap);
        }
    }

    public ClassObj getClassObj() {
        return this.myClassObj;
    }

    public void setClassObj(ClassObj classObj) {
        if (this.myClassObj != classObj && !this.mySelectionLocked) {
            this.myClassObj = classObj;
            ((SelectionListener)this.myDispatcher.getMulticaster()).onClassObjChanged(this.myClassObj);
        }
    }

    public Instance getInstance() {
        return this.myInstance;
    }

    public void setInstance(Instance instance) {
        if (this.myInstance != instance && !this.mySelectionLocked) {
            this.myInstance = instance;
            ((SelectionListener)this.myDispatcher.getMulticaster()).onInstanceChanged(this.myInstance);
        }
    }

    public void setSelectionLocked(boolean locked) {
        this.mySelectionLocked = locked;
    }

    public void addListener(SelectionListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
        listener.onHeapChanged(this.myHeap);
        listener.onClassObjChanged(this.myClassObj);
        listener.onInstanceChanged(this.myInstance);
    }

    public void removeListener(SelectionListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public static interface SelectionListener
    extends EventListener {
        public void onHeapChanged(Heap var1);

        public void onClassObjChanged(ClassObj var1);

        public void onInstanceChanged(Instance var1);
    }
}

